/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import rars.Globals;
import rars.ProgramStatement;
import rars.Settings;
import rars.SimulationException;
import rars.riscv.AbstractSyscall;
import rars.riscv.BasicInstruction;
import rars.riscv.ExtendedInstruction;
import rars.riscv.Instruction;
import rars.riscv.SyscallLoader;
import rars.riscv.hardware.RegisterFile;
import rars.util.FilenameFinder;

public class InstructionSet {
    private static final String CLASS_PREFIX = "rars.riscv.instructions.";
    private static final String INSTRUCTIONS_DIRECTORY_PATH = "rars/riscv/instructions";
    private static final String CLASS_EXTENSION = "class";
    public static boolean rv64 = Globals.getSettings().getBooleanSetting(Settings.Bool.RV64_ENABLED);
    private ArrayList<Instruction> instructionList = new ArrayList();
    private ArrayList<MatchMap> opcodeMatchMaps;

    public ArrayList<Instruction> getInstructionList() {
        return this.instructionList;
    }

    public void populate() {
        this.instructionList.clear();
        this.addBasicInstructions();
        if (rv64) {
            this.addPseudoInstructions("/PseudoOps-64.txt");
        }
        this.addPseudoInstructions("/PseudoOps.txt");
        for (Instruction object2 : this.instructionList) {
            object2.createExampleTokenList();
        }
        HashMap hashMap = new HashMap();
        ArrayList<MatchMap> arrayList = new ArrayList<MatchMap>();
        for (Instruction instruction : this.instructionList) {
            if (!(instruction instanceof BasicInstruction)) continue;
            BasicInstruction basicInstruction = (BasicInstruction)instruction;
            Integer n = basicInstruction.getOpcodeMask();
            Integer n2 = basicInstruction.getOpcodeMatch();
            HashMap<Integer, BasicInstruction> hashMap2 = (HashMap<Integer, BasicInstruction>)hashMap.get(n);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<Integer, BasicInstruction>();
                hashMap.put(n, hashMap2);
                arrayList.add(new MatchMap(n, hashMap2));
            }
            hashMap2.put(n2, basicInstruction);
        }
        Collections.sort(arrayList);
        this.opcodeMatchMaps = arrayList;
    }

    public BasicInstruction findByBinaryCode(int n) {
        for (MatchMap matchMap : this.opcodeMatchMaps) {
            BasicInstruction basicInstruction = matchMap.find(n);
            if (basicInstruction == null) continue;
            return basicInstruction;
        }
        return null;
    }

    private void addBasicInstructions() {
        ArrayList<String> arrayList = FilenameFinder.getFilenameList(this.getClass().getClassLoader(), INSTRUCTIONS_DIRECTORY_PATH, CLASS_EXTENSION);
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : arrayList) {
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
            try {
                String string2 = CLASS_PREFIX + string.substring(0, string.indexOf(CLASS_EXTENSION) - 1);
                Class<?> clazz = Class.forName(string2);
                if (!BasicInstruction.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) continue;
                try {
                    this.instructionList.add((BasicInstruction)clazz.newInstance());
                }
                catch (NullPointerException nullPointerException) {
                    if (nullPointerException.toString().contains("rv")) continue;
                    throw nullPointerException;
                }
            }
            catch (Exception exception) {
                System.out.println("Error instantiating Instruction from file " + string + ": " + exception);
                System.exit(0);
            }
        }
    }

    private void addPseudoInstructions(String string) {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            inputStream = this.getClass().getResourceAsStream(string);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Error: Pseudo-instruction file PseudoOps.txt not found.");
            System.exit(0);
        }
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("#") || string2.startsWith(" ") || string2.length() <= 0) continue;
                String string3 = "";
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
                String string4 = stringTokenizer.nextToken();
                String string5 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken();
                    if (string6.startsWith("#")) {
                        string3 = string6.substring(1);
                        break;
                    }
                    string5 = string5 + string6;
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    string5 = string5 + "\n";
                }
                this.instructionList.add(new ExtendedInstruction(string4, string5, string3));
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Internal Error: Pseudo-instructions could not be loaded.");
            System.exit(0);
        }
        catch (Exception exception) {
            System.out.println("Internal Error: Invalid pseudo-instruction specification.");
            System.exit(0);
        }
    }

    public ArrayList<Instruction> matchOperator(String string) {
        ArrayList<Instruction> arrayList = null;
        for (Instruction instruction : this.instructionList) {
            if (!instruction.getName().equalsIgnoreCase(string)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Instruction>();
            }
            arrayList.add(instruction);
        }
        return arrayList;
    }

    public ArrayList<Instruction> prefixMatchOperator(String string) {
        ArrayList<Instruction> arrayList = null;
        if (string != null) {
            for (Instruction instruction : this.instructionList) {
                if (!instruction.getName().toLowerCase().startsWith(string.toLowerCase())) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Instruction>();
                }
                arrayList.add(instruction);
            }
        }
        return arrayList;
    }

    public static void findAndSimulateSyscall(int n, ProgramStatement programStatement) throws SimulationException {
        AbstractSyscall abstractSyscall = SyscallLoader.findSyscall(n);
        if (abstractSyscall != null) {
            abstractSyscall.simulate(programStatement);
            return;
        }
        throw new SimulationException(programStatement, "invalid or unimplemented syscall service: " + n + " ", 8);
    }

    public static void processBranch(int n) {
        RegisterFile.setProgramCounter(RegisterFile.getProgramCounter() + (n << 1) - 4);
    }

    public static void processJump(int n) {
        RegisterFile.setProgramCounter(n);
    }

    public static void processReturnAddress(int n) {
        RegisterFile.updateRegister(n, (long)RegisterFile.getProgramCounter());
    }

    private static class MatchMap
    implements Comparable<MatchMap> {
        private int mask;
        private int maskLength;
        private HashMap<Integer, BasicInstruction> matchMap;

        public MatchMap(int n, HashMap<Integer, BasicInstruction> hashMap) {
            this.mask = n;
            this.matchMap = hashMap;
            int n2 = 0;
            for (int i = n; i != 0; i &= i - 1) {
                ++n2;
            }
            this.maskLength = n2;
        }

        public boolean equals(Object object) {
            return object instanceof MatchMap && this.mask == ((MatchMap)object).mask;
        }

        @Override
        public int compareTo(MatchMap matchMap) {
            int n = matchMap.maskLength - this.maskLength;
            if (n == 0) {
                n = this.mask - matchMap.mask;
            }
            return n;
        }

        public BasicInstruction find(int n) {
            int n2 = n & this.mask;
            return this.matchMap.get(n2);
        }
    }
}

