/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.hardware;

import java.util.Observer;
import rars.Globals;
import rars.riscv.hardware.LinkedRegister;
import rars.riscv.hardware.MaskedRegister;
import rars.riscv.hardware.ReadOnlyRegister;
import rars.riscv.hardware.Register;
import rars.riscv.hardware.RegisterBlock;

public class ControlAndStatusRegisterFile {
    public static final int EXTERNAL_INTERRUPT = 256;
    public static final int TIMER_INTERRUPT = 16;
    public static final int SOFTWARE_INTERRUPT = 1;
    public static final int INTERRUPT_ENABLE = 1;
    private static final RegisterBlock instance;

    public static boolean updateRegister(int n, long l) {
        if (instance.getRegister(n) instanceof ReadOnlyRegister) {
            return true;
        }
        if (n >= 3200 && n <= 3202) {
            return true;
        }
        if (Globals.getSettings().getBackSteppingEnabled()) {
            Globals.program.getBackStepper().addControlAndStatusRestore(n, instance.updateRegister(n, l));
        } else {
            instance.updateRegister(n, l);
        }
        return false;
    }

    public static void updateRegister(String string, long l) {
        ControlAndStatusRegisterFile.updateRegister(instance.getRegister(string).getNumber(), l);
    }

    public static void updateRegisterBackdoor(int n, long l) {
        if (Globals.getSettings().getBackSteppingEnabled()) {
            Globals.program.getBackStepper().addControlAndStatusBackdoor(n, instance.getRegister(n).setValueBackdoor(l));
        } else {
            instance.getRegister(n).setValueBackdoor(l);
        }
    }

    public static void updateRegisterBackdoor(String string, long l) {
        ControlAndStatusRegisterFile.updateRegisterBackdoor(instance.getRegister(string).getNumber(), l);
    }

    public static boolean orRegister(int n, long l) {
        return ControlAndStatusRegisterFile.updateRegister(n, instance.getValue(n) | l);
    }

    public static void orRegister(String string, long l) {
        ControlAndStatusRegisterFile.updateRegister(string, instance.getValue(string) | l);
    }

    public static boolean clearRegister(int n, long l) {
        return ControlAndStatusRegisterFile.updateRegister(n, instance.getValue(n) & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public static void clearRegister(String string, long l) {
        ControlAndStatusRegisterFile.updateRegister(string, instance.getValue(string) & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public static int getValue(int n) {
        return (int)instance.getValue(n);
    }

    public static long getValueLong(int n) {
        return instance.getValue(n);
    }

    public static int getValue(String string) {
        return (int)instance.getValue(string);
    }

    public static long getValueNoNotify(String string) {
        return instance.getRegister(string).getValueNoNotify();
    }

    public static Register[] getRegisters() {
        return instance.getRegisters();
    }

    public static int getRegisterPosition(Register register) {
        Register[] registerArray = instance.getRegisters();
        for (int i = 0; i < registerArray.length; ++i) {
            if (registerArray[i] != register) continue;
            return i;
        }
        return -1;
    }

    public static void resetRegisters() {
        instance.resetRegisters();
    }

    public static void addRegistersObserver(Observer observer) {
        instance.addRegistersObserver(observer);
    }

    public static void deleteRegistersObserver(Observer observer) {
        instance.deleteRegistersObserver(observer);
    }

    static {
        Register[] registerArray = new Register[]{new MaskedRegister("ustatus", 0, 0L, -18L), null, null, new MaskedRegister("fcsr", 3, 0L, -256L), new Register("uie", 4, 0L), new Register("utvec", 5, 0L), new Register("uscratch", 64, 0L), new Register("uepc", 65, 0L), new Register("ucause", 66, 0L), new Register("utval", 67, 0L), new Register("uip", 68, 0L), new ReadOnlyRegister("cycle", 3072, 0), new ReadOnlyRegister("time", 3073, 0), new ReadOnlyRegister("instret", 3074, 0), null, null, null};
        registerArray[1] = new LinkedRegister("fflags", 1, registerArray[3], 31L);
        registerArray[2] = new LinkedRegister("frm", 2, registerArray[3], 224L);
        registerArray[14] = new LinkedRegister("cycleh", 3200, registerArray[11], -4294967296L);
        registerArray[15] = new LinkedRegister("timeh", 3201, registerArray[12], -4294967296L);
        registerArray[16] = new LinkedRegister("instreth", 3202, registerArray[13], -4294967296L);
        instance = new RegisterBlock('_', registerArray);
    }
}

