/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.hardware;

import rars.riscv.hardware.Register;

public class LinkedRegister
extends Register {
    private Register base;
    private long mask;
    private int shift;

    public LinkedRegister(String string, int n, Register register, long l) {
        super(string, n, 0L);
        this.base = register;
        this.mask = l;
        this.shift = 0;
        while (l != 0L && (l & 1L) == 0L) {
            ++this.shift;
            l >>>= 1;
        }
    }

    @Override
    public synchronized long getValue() {
        super.getValue();
        return this.getValueNoNotify();
    }

    @Override
    public synchronized long getValueNoNotify() {
        return (this.base.getValueNoNotify() & this.mask) >>> this.shift;
    }

    @Override
    public synchronized long setValue(long l) {
        long l2 = this.base.getValueNoNotify();
        this.base.setValue(l << this.shift & this.mask | l2 & (this.mask ^ 0xFFFFFFFFFFFFFFFFL));
        super.setValue(0L);
        return (l2 & this.mask) >>> this.shift;
    }

    @Override
    public synchronized void resetValue() {
        this.base.resetValue();
    }
}

