/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.hardware;

import java.util.Observer;
import rars.riscv.hardware.Register;
import rars.util.Binary;

public class RegisterBlock {
    private final Register[] regFile;
    private final char prefix;

    protected RegisterBlock(char c, Register[] registerArray) {
        this.prefix = c;
        this.regFile = registerArray;
    }

    public void showRegisters() {
        for (Register register : this.regFile) {
            System.out.println("Name: " + register.getName());
            System.out.println("Number: " + register.getNumber());
            System.out.println("Value: " + register.getValue());
            System.out.println("");
        }
    }

    public long updateRegister(Register register, long l) {
        if (register == null) {
            return 0L;
        }
        return register.setValue(l);
    }

    public long updateRegister(int n, long l) {
        return this.updateRegister(this.getRegister(n), l);
    }

    public long updateRegister(String string, long l) {
        return this.updateRegister(this.getRegister(string), l);
    }

    public long getValue(int n) {
        return this.getRegister(n).getValue();
    }

    public long getValue(String string) {
        return this.getRegister(string).getValue();
    }

    public Register getRegister(int n) {
        for (Register register : this.regFile) {
            if (register.getNumber() != n) continue;
            return register;
        }
        return null;
    }

    public Register getRegister(String string) {
        if (string.length() < 2) {
            return null;
        }
        for (Register register : this.regFile) {
            if (!register.getName().equals(string)) continue;
            return register;
        }
        if (string.charAt(0) == this.prefix) {
            if (string.charAt(1) == '\u0000') {
                if (string.length() > 2) {
                    return null;
                }
                return this.getRegister(0);
            }
            Integer n = Binary.stringToIntFast(string.substring(1));
            if (n == null) {
                return null;
            }
            return this.getRegister(n);
        }
        return null;
    }

    public Register[] getRegisters() {
        return this.regFile;
    }

    public void resetRegisters() {
        for (Register register : this.regFile) {
            register.resetValue();
        }
    }

    public void addRegistersObserver(Observer observer) {
        for (Register register : this.regFile) {
            register.addObserver(observer);
        }
    }

    public void deleteRegistersObserver(Observer observer) {
        for (Register register : this.regFile) {
            register.deleteObserver(observer);
        }
    }
}

