/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import jsoftfloat.Environment;
import jsoftfloat.types.Float64;
import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.instructions.Floating;

public abstract class Double
extends BasicInstruction {
    protected Double(String string, String string2, String string3) {
        super(string + " f1, f2, f3, dyn", string2, BasicInstructionFormat.R_FORMAT, string3 + "ttttt sssss qqq fffff 1010011");
    }

    protected Double(String string, String string2, String string3, String string4) {
        super(string + " f1, f2, f3", string2, BasicInstructionFormat.R_FORMAT, string3 + "ttttt sssss " + string4 + " fffff 1010011");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        Environment environment = new Environment();
        environment.mode = Floating.getRoundingMode(nArray[3], programStatement);
        Float64 float64 = this.compute(new Float64(FloatingPointRegisterFile.getValueLong(nArray[1])), new Float64(FloatingPointRegisterFile.getValueLong(nArray[2])), environment);
        Floating.setfflags(environment);
        FloatingPointRegisterFile.updateRegisterLong(nArray[0], float64.bits);
    }

    public abstract Float64 compute(Float64 var1, Float64 var2, Environment var3);

    public static Float64 getDouble(int n) {
        return new Float64(FloatingPointRegisterFile.getValueLong(n));
    }
}

