/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import jsoftfloat.Environment;
import jsoftfloat.RoundingMode;
import jsoftfloat.types.Float32;
import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.instructions.Floating;

public abstract class FusedFloat
extends BasicInstruction {
    public FusedFloat(String string, String string2, String string3) {
        super(string + ", dyn", string2, BasicInstructionFormat.R4_FORMAT, "qqqqq 00 ttttt sssss ppp fffff 100" + string3 + "11");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        Environment environment = new Environment();
        environment.mode = Floating.getRoundingMode(nArray[4], programStatement);
        Float32 float32 = this.compute(new Float32(FloatingPointRegisterFile.getValue(nArray[1])), new Float32(FloatingPointRegisterFile.getValue(nArray[2])), new Float32(FloatingPointRegisterFile.getValue(nArray[3])), environment);
        Floating.setfflags(environment);
        FloatingPointRegisterFile.updateRegister(nArray[0], float32.bits);
    }

    public static void flipRounding(Environment environment) {
        if (environment.mode == RoundingMode.max) {
            environment.mode = RoundingMode.min;
        } else if (environment.mode == RoundingMode.min) {
            environment.mode = RoundingMode.max;
        }
    }

    protected abstract Float32 compute(Float32 var1, Float32 var2, Float32 var3, Environment var4);
}

