/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.syscalls;

import java.nio.charset.StandardCharsets;
import javax.swing.JOptionPane;
import rars.ExitingException;
import rars.Globals;
import rars.ProgramStatement;
import rars.riscv.AbstractSyscall;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.RegisterFile;
import rars.riscv.syscalls.NullString;

public class SyscallInputDialogString
extends AbstractSyscall {
    public SyscallInputDialogString() {
        super("InputDialogString");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws ExitingException {
        String string = NullString.get(programStatement);
        String string2 = null;
        string2 = JOptionPane.showInputDialog(string);
        int n = RegisterFile.getValue("a1");
        int n2 = RegisterFile.getValue("a2");
        try {
            if (string2 == null) {
                RegisterFile.updateRegister("a1", -2L);
            } else if (string2.length() == 0) {
                RegisterFile.updateRegister("a1", -3L);
            } else {
                byte[] byArray = string2.getBytes(StandardCharsets.UTF_8);
                int n3 = Math.min(n2 - 1, byArray.length);
                for (int i = 0; i < n3; ++i) {
                    Globals.memory.setByte(n + i, byArray[i]);
                }
                if (n3 < n2 - 1) {
                    Globals.memory.setByte(n + n3, 10);
                    ++n3;
                }
                Globals.memory.setByte(n + n3, 0);
                if (byArray.length > n2 - 1) {
                    RegisterFile.updateRegister("a1", -4L);
                } else {
                    RegisterFile.updateRegister("a1", 0L);
                }
            }
        }
        catch (AddressErrorException addressErrorException) {
            throw new ExitingException(programStatement, addressErrorException);
        }
    }
}

