/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.syscalls;

import java.util.Random;
import rars.ExitingException;
import rars.ProgramStatement;
import rars.riscv.AbstractSyscall;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.RegisterFile;
import rars.riscv.syscalls.RandomStreams;

public class SyscallRandDouble
extends AbstractSyscall {
    public SyscallRandDouble() {
        super("RandDouble", "Get a random double from the range 0.0-1.0", "a0 = index of pseudorandom number generator", "fa0 = the next pseudorandom");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws ExitingException {
        Integer n = RegisterFile.getValue("a0");
        Random random = RandomStreams.randomStreams.get(n);
        if (random == null) {
            random = new Random();
            RandomStreams.randomStreams.put(n, random);
        }
        FloatingPointRegisterFile.updateRegisterLong(10, Double.doubleToRawLongBits(random.nextDouble()));
    }
}

