/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.syscalls;

import rars.ExitingException;
import rars.ProgramStatement;
import rars.riscv.AbstractSyscall;
import rars.riscv.hardware.RegisterFile;
import rars.util.SystemIO;

public class SyscallReadChar
extends AbstractSyscall {
    public SyscallReadChar() {
        super("ReadChar", "Read a character from input console", "N/A", "a0 = the character");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws ExitingException {
        try {
            RegisterFile.updateRegister("a0", (long)SystemIO.readChar(this.getNumber()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ExitingException(programStatement, "invalid char input (syscall " + this.getNumber() + ")");
        }
    }
}

