/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.syscalls;

import rars.ExitingException;
import rars.ProgramStatement;
import rars.riscv.AbstractSyscall;
import rars.riscv.hardware.RegisterFile;
import rars.util.SystemIO;

public class SyscallReadInt
extends AbstractSyscall {
    public SyscallReadInt() {
        super("ReadInt", "Read an int from input console", "N/A", "a0 = the int");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws ExitingException {
        try {
            RegisterFile.updateRegister("a0", (long)SystemIO.readInteger(this.getNumber()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExitingException(programStatement, "invalid integer input (syscall " + this.getNumber() + ")");
        }
    }
}

