/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.syscalls;

import java.nio.charset.StandardCharsets;
import rars.ExitingException;
import rars.Globals;
import rars.ProgramStatement;
import rars.riscv.AbstractSyscall;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.RegisterFile;
import rars.util.SystemIO;

public class SyscallReadString
extends AbstractSyscall {
    public SyscallReadString() {
        super("ReadString", "Reads a string from the console", "a0 = address of input buffer<br>a1 = maximum number of characters to read", "N/A");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws ExitingException {
        String string = "";
        int n = RegisterFile.getValue("a0");
        int n2 = RegisterFile.getValue("a1") - 1;
        boolean bl = true;
        if (n2 < 0) {
            n2 = 0;
            bl = false;
        }
        string = SystemIO.readString(this.getNumber(), n2);
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        int n3 = Math.min(n2, byArray.length);
        try {
            for (int i = 0; i < n3; ++i) {
                Globals.memory.setByte(n + i, byArray[i]);
            }
            if (n3 < n2) {
                Globals.memory.setByte(n + n3, 10);
                ++n3;
            }
            if (bl) {
                Globals.memory.setByte(n + n3, 0);
            }
        }
        catch (AddressErrorException addressErrorException) {
            throw new ExitingException(programStatement, addressErrorException);
        }
    }
}

