/*
 * Decompiled with CFR 0.152.
 */
package rars.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;

public class BHTSimGUI
extends JPanel {
    private JTextField m_tfInstruction;
    private JTextField m_tfAddress;
    private JTextField m_tfIndex;
    private JComboBox<Integer> m_cbBHTentries;
    private JComboBox<Integer> m_cbBHThistory;
    private JComboBox<String> m_cbBHTinitVal;
    private JTable m_tabBHT;
    private JTextArea m_taLog;
    public static final Color COLOR_PREPREDICTION = Color.yellow;
    public static final Color COLOR_PREDICTION_CORRECT = Color.green;
    public static final Color COLOR_PREDICTION_INCORRECT = Color.red;
    public static final String BHT_TAKE_BRANCH = "TAKE";
    public static final String BHT_DO_NOT_TAKE_BRANCH = "NOT TAKE";

    public BHTSimGUI() {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(10);
        borderLayout.setHgap(10);
        this.setLayout(borderLayout);
        this.m_tabBHT = this.createAndInitTable();
        this.add((Component)this.buildConfigPanel(), "North");
        this.add((Component)this.buildInfoPanel(), "West");
        this.add((Component)new JScrollPane(this.m_tabBHT), "Center");
        this.add((Component)this.buildLogPanel(), "South");
    }

    private JTable createAndInitTable() {
        JTable jTable = new JTable();
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){
            private DecimalFormat formatter = new DecimalFormat("##0.00");

            @Override
            public void setValue(Object object) {
                this.setText(object == null ? "" : this.formatter.format(object));
            }
        };
        defaultTableCellRenderer.setHorizontalAlignment(0);
        DefaultTableCellRenderer defaultTableCellRenderer2 = new DefaultTableCellRenderer();
        defaultTableCellRenderer2.setHorizontalAlignment(0);
        jTable.setDefaultRenderer(Double.class, defaultTableCellRenderer);
        jTable.setDefaultRenderer(Integer.class, defaultTableCellRenderer2);
        jTable.setDefaultRenderer(String.class, defaultTableCellRenderer2);
        jTable.setSelectionBackground(COLOR_PREPREDICTION);
        jTable.setSelectionMode(1);
        return jTable;
    }

    private JPanel buildInfoPanel() {
        this.m_tfInstruction = new JTextField();
        this.m_tfAddress = new JTextField();
        this.m_tfIndex = new JTextField();
        this.m_tfInstruction.setColumns(10);
        this.m_tfInstruction.setEditable(false);
        this.m_tfInstruction.setHorizontalAlignment(0);
        this.m_tfAddress.setColumns(10);
        this.m_tfAddress.setEditable(false);
        this.m_tfAddress.setHorizontalAlignment(0);
        this.m_tfIndex.setColumns(10);
        this.m_tfIndex.setEditable(false);
        this.m_tfIndex.setHorizontalAlignment(0);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 2, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel("Instruction"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.m_tfInstruction, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("@ Address"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.m_tfAddress, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("-> Index"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.m_tfIndex, gridBagConstraints);
        jPanel2.add((Component)jPanel, "North");
        return jPanel2;
    }

    private JPanel buildConfigPanel() {
        JPanel jPanel = new JPanel();
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(8);
        vector.add(16);
        vector.add(32);
        Vector<Integer> vector2 = new Vector<Integer>();
        vector2.add(1);
        vector2.add(2);
        Vector<String> vector3 = new Vector<String>();
        vector3.add(BHT_DO_NOT_TAKE_BRANCH);
        vector3.add(BHT_TAKE_BRANCH);
        this.m_cbBHTentries = new JComboBox(vector);
        this.m_cbBHThistory = new JComboBox(vector2);
        this.m_cbBHTinitVal = new JComboBox(vector3);
        jPanel.add(new JLabel("# of BHT entries"));
        jPanel.add(this.m_cbBHTentries);
        jPanel.add(new JLabel("BHT history size"));
        jPanel.add(this.m_cbBHThistory);
        jPanel.add(new JLabel("Initial value"));
        jPanel.add(this.m_cbBHTinitVal);
        return jPanel;
    }

    private JPanel buildLogPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.m_taLog = new JTextArea();
        this.m_taLog.setRows(6);
        this.m_taLog.setEditable(false);
        jPanel.add((Component)new JLabel("Log"), "North");
        jPanel.add((Component)new JScrollPane(this.m_taLog), "Center");
        return jPanel;
    }

    public JComboBox<Integer> getCbBHTentries() {
        return this.m_cbBHTentries;
    }

    public JComboBox<Integer> getCbBHThistory() {
        return this.m_cbBHThistory;
    }

    public JComboBox<String> getCbBHTinitVal() {
        return this.m_cbBHTinitVal;
    }

    public JTable getTabBHT() {
        return this.m_tabBHT;
    }

    public JTextArea getTaLog() {
        return this.m_taLog;
    }

    public JTextField getTfInstruction() {
        return this.m_tfInstruction;
    }

    public JTextField getTfAddress() {
        return this.m_tfAddress;
    }

    public JTextField getTfIndex() {
        return this.m_tfIndex;
    }
}

