/*
 * Decompiled with CFR 0.152.
 */
package rars.tools;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import rars.tools.BHTEntry;

public class BHTableModel
extends AbstractTableModel {
    private Vector<BHTEntry> m_entries;
    private int m_entryCnt;
    private String[] m_columnNames = new String[]{"Index", "History", "Prediction", "Correct", "Incorrect", "Precision"};
    private Class[] m_columnClasses = new Class[]{Integer.class, String.class, String.class, Integer.class, Integer.class, Double.class};

    public BHTableModel(int n, int n2, boolean bl) {
        this.initBHT(n, n2, bl);
    }

    @Override
    public String getColumnName(int n) {
        if (n < 0 || n > this.m_columnNames.length) {
            throw new IllegalArgumentException("Illegal column index " + n + " (must be in range 0.." + (this.m_columnNames.length - 1) + ")");
        }
        return this.m_columnNames[n];
    }

    public Class getColumnClass(int n) {
        if (n < 0 || n > this.m_columnClasses.length) {
            throw new IllegalArgumentException("Illegal column index " + n + " (must be in range 0.." + (this.m_columnClasses.length - 1) + ")");
        }
        return this.m_columnClasses[n];
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public int getRowCount() {
        return this.m_entryCnt;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        BHTEntry bHTEntry = this.m_entries.elementAt(n);
        if (bHTEntry == null) {
            return "";
        }
        if (n2 == 0) {
            return n;
        }
        if (n2 == 1) {
            return bHTEntry.getHistoryAsStr();
        }
        if (n2 == 2) {
            return bHTEntry.getPredictionAsStr();
        }
        if (n2 == 3) {
            return bHTEntry.getStatsPredCorrect();
        }
        if (n2 == 4) {
            return bHTEntry.getStatsPredIncorrect();
        }
        if (n2 == 5) {
            return bHTEntry.getStatsPredPrecision();
        }
        return "";
    }

    public void initBHT(int n, int n2, boolean bl) {
        if (n <= 0 || (n & n - 1) != 0) {
            throw new IllegalArgumentException("Number of entries must be a positive power of 2.");
        }
        if (n2 < 1 || n2 > 2) {
            throw new IllegalArgumentException("Only history sizes of 1 or 2 supported.");
        }
        this.m_entryCnt = n;
        this.m_entries = new Vector();
        for (int i = 0; i < this.m_entryCnt; ++i) {
            this.m_entries.add(new BHTEntry(n2, bl));
        }
        this.fireTableStructureChanged();
    }

    public int getIdxForAddress(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("No negative addresses supported");
        }
        return (n >> 2) % this.m_entryCnt;
    }

    public boolean getPredictionAtIdx(int n) {
        if (n < 0 || n > this.m_entryCnt) {
            throw new IllegalArgumentException("Only indexes in the range 0 to " + (this.m_entryCnt - 1) + " allowed");
        }
        return this.m_entries.elementAt(n).getPrediction();
    }

    public void updatePredictionAtIdx(int n, boolean bl) {
        if (n < 0 || n > this.m_entryCnt) {
            throw new IllegalArgumentException("Only indexes in the range 0 to " + (this.m_entryCnt - 1) + " allowed");
        }
        this.m_entries.elementAt(n).updatePrediction(bl);
        this.fireTableRowsUpdated(n, n);
    }
}

