/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.registers;

import rars.Globals;
import rars.Settings;
import rars.riscv.hardware.ControlAndStatusRegisterFile;
import rars.riscv.hardware.Register;
import rars.venus.NumberDisplayBaseChooser;
import rars.venus.registers.RegisterBlockWindow;

public class ControlAndStatusWindow
extends RegisterBlockWindow {
    private static final String[] regToolTips = new String[]{"Interrupt status information (set the lowest bit to enable exceptions)", "The accumulated floating point flags", "Rounding mode for floating point operatations", "Both frm and fflags", "Finer control for which interrupts are enabled", "The base address of the interrupt handler", "Scratch for processing inside the interrupt handler", "PC at the time the interrupt was triggered", "Cause of the interrupt (top bit is interrupt vs trap)", "Value associated with the cause", "Shows if any interrupt is pending and what type", "Number of clock cycles executed", "Time since some time in the past (Milliseconds since 1/1/1970 in RARS)", "Instructions retired (same as cycle in RARS)", "High 32 bits of cycle", "High 32 bits of time", "High 32 bits of instret"};

    public ControlAndStatusWindow() {
        super(ControlAndStatusRegisterFile.getRegisters(), regToolTips, "Current 32 bit value");
    }

    @Override
    protected String formatRegister(Register register, int n) {
        if (Globals.getSettings().getBooleanSetting(Settings.Bool.RV64_ENABLED)) {
            return NumberDisplayBaseChooser.formatNumber(register.getValue(), n);
        }
        return NumberDisplayBaseChooser.formatNumber((int)register.getValue(), n);
    }

    @Override
    protected void beginObserving() {
        ControlAndStatusRegisterFile.addRegistersObserver(this);
    }

    @Override
    protected void endObserving() {
        ControlAndStatusRegisterFile.deleteRegistersObserver(this);
    }

    @Override
    public void resetRegisters() {
        ControlAndStatusRegisterFile.resetRegisters();
    }
}

