/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;
import rars.Globals;
import rars.Settings;
import rars.venus.GuiAction;
import rars.venus.editors.jeditsyntax.SyntaxStyle;
import rars.venus.editors.jeditsyntax.SyntaxUtilities;
import rars.venus.editors.jeditsyntax.tokenmarker.RISCVTokenMarker;
import rars.venus.settings.ColorSelectButton;
import rars.venus.util.AbstractFontSettingDialog;

public class SettingsEditorAction
extends GuiAction {
    private JDialog editorDialog;
    private static final int gridVGap = 2;
    private static final int gridHGap = 2;
    private static final Border ColorSelectButtonEnabledBorder = new BevelBorder(0, Color.WHITE, Color.GRAY);
    private static final Border ColorSelectButtonDisabledBorder = new LineBorder(Color.GRAY, 2);
    private static final String GENERIC_TOOL_TIP_TEXT = "Use generic editor (original RARS editor, similar to Notepad) instead of language-aware styled editor";
    private static final String SAMPLE_TOOL_TIP_TEXT = "Current setting; modify using buttons to the right";
    private static final String FOREGROUND_TOOL_TIP_TEXT = "Click, to select text color";
    private static final String BOLD_TOOL_TIP_TEXT = "Toggle text bold style";
    private static final String ITALIC_TOOL_TIP_TEXT = "Toggle text italic style";
    private static final String DEFAULT_TOOL_TIP_TEXT = "Check, to select defaults (disables buttons)";
    private static final String BOLD_BUTTON_TOOL_TIP_TEXT = "B";
    private static final String ITALIC_BUTTON_TOOL_TIP_TEXT = "I";
    private static final String TAB_SIZE_TOOL_TIP_TEXT = "Current tab size in characters";
    private static final String BLINK_SPINNER_TOOL_TIP_TEXT = "Current blinking rate in milliseconds";
    private static final String BLINK_SAMPLE_TOOL_TIP_TEXT = "Displays current blinking rate";
    private static final String CURRENT_LINE_HIGHLIGHT_TOOL_TIP_TEXT = "Check, to highlight line currently being edited";
    private static final String AUTO_INDENT_TOOL_TIP_TEXT = "Check, to enable auto-indent to previous line when Enter key is pressed";
    private static final String[] POPUP_GUIDANCE_TOOL_TIP_TEXT = new String[]{"Turns off instruction and directive guide popup while typing", "Generates instruction guide popup after first letter of potential instruction is typed", "Generates instruction guide popup after second letter of potential instruction is typed"};

    public SettingsEditorAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
        super(string, icon, string2, n, keyStroke);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.editorDialog = new EditorFontDialog(Globals.getGui(), "Text Editor Settings", true, Globals.getSettings().getEditorFont());
        this.editorDialog.setVisible(true);
    }

    private class EditorFontDialog
    extends AbstractFontSettingDialog {
        private JButton[] foregroundButtons;
        private JLabel[] samples;
        private JToggleButton[] bold;
        private JToggleButton[] italic;
        private JCheckBox[] useDefault;
        private int[] syntaxStyleIndex;
        private SyntaxStyle[] defaultStyles;
        private SyntaxStyle[] initialStyles;
        private SyntaxStyle[] currentStyles;
        private Font previewFont;
        private JPanel dialogPanel;
        private JPanel syntaxStylePanel;
        private JPanel otherSettingsPanel;
        private JSlider tabSizeSelector;
        private JSpinner tabSizeSpinSelector;
        private JSpinner blinkRateSpinSelector;
        private JSpinner popupPrefixLengthSpinSelector;
        private JCheckBox lineHighlightCheck;
        private JCheckBox genericEditorCheck;
        private JCheckBox autoIndentCheck;
        private Caret blinkCaret;
        private JTextField blinkSample;
        private ButtonGroup popupGuidanceButtons;
        private JRadioButton[] popupGuidanceOptions;
        private boolean syntaxStylesAction;
        private int initialEditorTabSize;
        private int initialCaretBlinkRate;
        private int initialPopupGuidance;
        private boolean initialLineHighlighting;
        private boolean initialGenericTextEditor;
        private boolean initialAutoIndent;

        public EditorFontDialog(Frame frame, String string, boolean bl, Font font) {
            super(frame, string, bl, font);
            this.syntaxStylesAction = false;
            if (Globals.getSettings().getBooleanSetting(Settings.Bool.GENERIC_TEXT_EDITOR)) {
                this.syntaxStylePanel.setVisible(false);
                this.otherSettingsPanel.setVisible(false);
            }
        }

        @Override
        protected JPanel buildDialogPanel() {
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = super.buildDialogPanel();
            JPanel jPanel3 = this.buildSyntaxStylePanel();
            JPanel jPanel4 = this.buildOtherSettingsPanel();
            jPanel2.setBorder(BorderFactory.createTitledBorder("Editor Font"));
            jPanel3.setBorder(BorderFactory.createTitledBorder("Syntax Styling"));
            jPanel4.setBorder(BorderFactory.createTitledBorder("Other Editor Settings"));
            jPanel.add((Component)jPanel2, "West");
            jPanel.add((Component)jPanel3, "Center");
            jPanel.add((Component)jPanel4, "South");
            this.dialogPanel = jPanel;
            this.syntaxStylePanel = jPanel3;
            this.otherSettingsPanel = jPanel4;
            return jPanel;
        }

        @Override
        protected Component buildControlPanel() {
            Box box = Box.createHorizontalBox();
            JButton jButton = new JButton("Apply and Close");
            jButton.setToolTipText("Apply current settings and close dialog");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditorFontDialog.this.performApply();
                    EditorFontDialog.this.closeDialog();
                }
            });
            JButton jButton2 = new JButton("Apply");
            jButton2.setToolTipText("Apply current settings now and leave dialog open");
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditorFontDialog.this.performApply();
                }
            });
            JButton jButton3 = new JButton("Cancel");
            jButton3.setToolTipText("Close dialog without applying current settings");
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditorFontDialog.this.closeDialog();
                }
            });
            JButton jButton4 = new JButton("Reset");
            jButton4.setToolTipText("Reset to initial settings without applying");
            jButton4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditorFontDialog.this.reset();
                }
            });
            this.initialGenericTextEditor = Globals.getSettings().getBooleanSetting(Settings.Bool.GENERIC_TEXT_EDITOR);
            this.genericEditorCheck = new JCheckBox("Use Generic Editor", this.initialGenericTextEditor);
            this.genericEditorCheck.setToolTipText(SettingsEditorAction.GENERIC_TOOL_TIP_TEXT);
            this.genericEditorCheck.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        EditorFontDialog.this.syntaxStylePanel.setVisible(false);
                        EditorFontDialog.this.otherSettingsPanel.setVisible(false);
                    } else {
                        EditorFontDialog.this.syntaxStylePanel.setVisible(true);
                        EditorFontDialog.this.otherSettingsPanel.setVisible(true);
                    }
                }
            });
            box.add(Box.createHorizontalGlue());
            box.add(jButton);
            box.add(Box.createHorizontalGlue());
            box.add(jButton2);
            box.add(Box.createHorizontalGlue());
            box.add(jButton3);
            box.add(Box.createHorizontalGlue());
            box.add(jButton4);
            box.add(Box.createHorizontalGlue());
            box.add(this.genericEditorCheck);
            box.add(Box.createHorizontalGlue());
            return box;
        }

        @Override
        protected void apply(Font font) {
            int n;
            Globals.getSettings().setBooleanSetting(Settings.Bool.GENERIC_TEXT_EDITOR, this.genericEditorCheck.isSelected());
            Globals.getSettings().setBooleanSetting(Settings.Bool.EDITOR_CURRENT_LINE_HIGHLIGHTING, this.lineHighlightCheck.isSelected());
            Globals.getSettings().setBooleanSetting(Settings.Bool.AUTO_INDENT, this.autoIndentCheck.isSelected());
            Globals.getSettings().setCaretBlinkRate((Integer)this.blinkRateSpinSelector.getValue());
            Globals.getSettings().setEditorTabSize(this.tabSizeSelector.getValue());
            if (this.syntaxStylesAction) {
                for (n = 0; n < this.syntaxStyleIndex.length; ++n) {
                    Globals.getSettings().setEditorSyntaxStyleByPosition(this.syntaxStyleIndex[n], new SyntaxStyle(this.samples[n].getForeground(), this.italic[n].isSelected(), this.bold[n].isSelected()));
                }
                this.syntaxStylesAction = false;
            }
            Globals.getSettings().setEditorFont(font);
            for (n = 0; n < this.popupGuidanceOptions.length; ++n) {
                if (!this.popupGuidanceOptions[n].isSelected()) continue;
                if (n == 0) {
                    Globals.getSettings().setBooleanSetting(Settings.Bool.POPUP_INSTRUCTION_GUIDANCE, false);
                    break;
                }
                Globals.getSettings().setBooleanSetting(Settings.Bool.POPUP_INSTRUCTION_GUIDANCE, true);
                Globals.getSettings().setEditorPopupPrefixLength(n);
                break;
            }
        }

        @Override
        protected void reset() {
            super.reset();
            this.initializeSyntaxStyleChangeables();
            this.resetOtherSettings();
            this.syntaxStylesAction = true;
            this.genericEditorCheck.setSelected(this.initialGenericTextEditor);
        }

        private void resetOtherSettings() {
            this.tabSizeSelector.setValue(this.initialEditorTabSize);
            this.tabSizeSpinSelector.setValue(this.initialEditorTabSize);
            this.lineHighlightCheck.setSelected(this.initialLineHighlighting);
            this.autoIndentCheck.setSelected(this.initialAutoIndent);
            this.blinkRateSpinSelector.setValue(this.initialCaretBlinkRate);
            this.blinkCaret.setBlinkRate(this.initialCaretBlinkRate);
            this.popupGuidanceOptions[this.initialPopupGuidance].setSelected(true);
        }

        private JPanel buildOtherSettingsPanel() {
            JPanel jPanel = new JPanel();
            this.initialEditorTabSize = Globals.getSettings().getEditorTabSize();
            this.tabSizeSelector = new JSlider(1, 32, this.initialEditorTabSize);
            this.tabSizeSelector.setToolTipText("Use slider to select tab size from 1 to 32.");
            this.tabSizeSelector.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    Integer n = ((JSlider)changeEvent.getSource()).getValue();
                    EditorFontDialog.this.tabSizeSpinSelector.setValue(n);
                }
            });
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.initialEditorTabSize, 1, 32, 1);
            this.tabSizeSpinSelector = new JSpinner(spinnerNumberModel);
            this.tabSizeSpinSelector.setToolTipText(SettingsEditorAction.TAB_SIZE_TOOL_TIP_TEXT);
            this.tabSizeSpinSelector.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    Object object = ((JSpinner)changeEvent.getSource()).getValue();
                    EditorFontDialog.this.tabSizeSelector.setValue((Integer)object);
                }
            });
            this.initialLineHighlighting = Globals.getSettings().getBooleanSetting(Settings.Bool.EDITOR_CURRENT_LINE_HIGHLIGHTING);
            this.lineHighlightCheck = new JCheckBox("Highlight the line currently being edited");
            this.lineHighlightCheck.setSelected(this.initialLineHighlighting);
            this.lineHighlightCheck.setToolTipText(SettingsEditorAction.CURRENT_LINE_HIGHLIGHT_TOOL_TIP_TEXT);
            this.initialAutoIndent = Globals.getSettings().getBooleanSetting(Settings.Bool.AUTO_INDENT);
            this.autoIndentCheck = new JCheckBox("Auto-Indent");
            this.autoIndentCheck.setSelected(this.initialAutoIndent);
            this.autoIndentCheck.setToolTipText(SettingsEditorAction.AUTO_INDENT_TOOL_TIP_TEXT);
            this.initialCaretBlinkRate = Globals.getSettings().getCaretBlinkRate();
            this.blinkSample = new JTextField("     ");
            this.blinkSample.setCaretPosition(2);
            this.blinkSample.setToolTipText(SettingsEditorAction.BLINK_SAMPLE_TOOL_TIP_TEXT);
            this.blinkSample.setEnabled(false);
            this.blinkCaret = this.blinkSample.getCaret();
            this.blinkCaret.setBlinkRate(this.initialCaretBlinkRate);
            this.blinkCaret.setVisible(true);
            SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(this.initialCaretBlinkRate, 0, 1000, 100);
            this.blinkRateSpinSelector = new JSpinner(spinnerNumberModel2);
            this.blinkRateSpinSelector.setToolTipText(SettingsEditorAction.BLINK_SPINNER_TOOL_TIP_TEXT);
            this.blinkRateSpinSelector.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    Object object = ((JSpinner)changeEvent.getSource()).getValue();
                    EditorFontDialog.this.blinkCaret.setBlinkRate((Integer)object);
                    EditorFontDialog.this.blinkSample.requestFocus();
                    EditorFontDialog.this.blinkCaret.setVisible(true);
                }
            });
            JPanel jPanel2 = new JPanel(new FlowLayout(0));
            jPanel2.add(new JLabel("Tab Size"));
            jPanel2.add(this.tabSizeSelector);
            jPanel2.add(this.tabSizeSpinSelector);
            JPanel jPanel3 = new JPanel(new FlowLayout(0));
            jPanel3.add(new JLabel("Cursor Blinking Rate in ms (0=no blink)"));
            jPanel3.add(this.blinkRateSpinSelector);
            jPanel3.add(this.blinkSample);
            jPanel.setLayout(new GridLayout(1, 2));
            JPanel jPanel4 = new JPanel(new GridLayout(4, 1));
            jPanel4.add(jPanel2);
            jPanel4.add(jPanel3);
            jPanel4.add(this.lineHighlightCheck);
            jPanel4.add(this.autoIndentCheck);
            JPanel jPanel5 = new JPanel(new GridLayout(4, 1));
            this.popupGuidanceButtons = new ButtonGroup();
            this.popupGuidanceOptions = new JRadioButton[3];
            this.popupGuidanceOptions[0] = new JRadioButton("No popup instruction or directive guide");
            this.popupGuidanceOptions[1] = new JRadioButton("Display instruction guide after 1 letter typed");
            this.popupGuidanceOptions[2] = new JRadioButton("Display instruction guide after 2 letters typed");
            for (int i = 0; i < this.popupGuidanceOptions.length; ++i) {
                this.popupGuidanceOptions[i].setSelected(false);
                this.popupGuidanceOptions[i].setToolTipText(POPUP_GUIDANCE_TOOL_TIP_TEXT[i]);
                this.popupGuidanceButtons.add(this.popupGuidanceOptions[i]);
            }
            this.initialPopupGuidance = Globals.getSettings().getBooleanSetting(Settings.Bool.POPUP_INSTRUCTION_GUIDANCE) ? Globals.getSettings().getEditorPopupPrefixLength() : 0;
            this.popupGuidanceOptions[this.initialPopupGuidance].setSelected(true);
            JPanel jPanel6 = new JPanel(new GridLayout(3, 1));
            jPanel5.setBorder(BorderFactory.createTitledBorder("Popup Instruction Guide"));
            jPanel5.add(this.popupGuidanceOptions[0]);
            jPanel5.add(this.popupGuidanceOptions[1]);
            jPanel5.add(this.popupGuidanceOptions[2]);
            jPanel.add(jPanel4);
            jPanel.add(jPanel5);
            return jPanel;
        }

        private JPanel buildSyntaxStylePanel() {
            Object object;
            JPanel jPanel = new JPanel();
            this.defaultStyles = SyntaxUtilities.getDefaultSyntaxStyles();
            this.initialStyles = SyntaxUtilities.getCurrentSyntaxStyles();
            String[] stringArray = RISCVTokenMarker.getRISCVTokenLabels();
            String[] stringArray2 = RISCVTokenMarker.getRISCVTokenExamples();
            this.syntaxStylesAction = false;
            int n = 0;
            for (String object22 : stringArray) {
                if (object22 == null) continue;
                ++n;
            }
            this.syntaxStyleIndex = new int[n];
            this.currentStyles = new SyntaxStyle[n];
            String[] stringArray3 = new String[n];
            this.samples = new JLabel[n];
            this.foregroundButtons = new JButton[n];
            this.bold = new JToggleButton[n];
            this.italic = new JToggleButton[n];
            this.useDefault = new JCheckBox[n];
            Font font = new JLabel().getFont();
            this.previewFont = new Font("Monospaced", 0, font.getSize());
            Font font2 = new Font("Serif", 1, font.getSize());
            Font font3 = new Font("Serif", 2, font.getSize());
            n = 0;
            for (int jPanel2 = 0; jPanel2 < stringArray.length; ++jPanel2) {
                if (stringArray[jPanel2] == null) continue;
                this.syntaxStyleIndex[n] = jPanel2;
                this.samples[n] = new JLabel();
                this.samples[n].setOpaque(true);
                this.samples[n].setHorizontalAlignment(0);
                this.samples[n].setBorder(BorderFactory.createLineBorder(Color.black));
                this.samples[n].setText(stringArray2[jPanel2]);
                this.samples[n].setBackground(Color.WHITE);
                this.samples[n].setToolTipText(SettingsEditorAction.SAMPLE_TOOL_TIP_TEXT);
                this.foregroundButtons[n] = new ColorSelectButton();
                this.foregroundButtons[n].addActionListener(new ForegroundChanger(n));
                this.foregroundButtons[n].setToolTipText(SettingsEditorAction.FOREGROUND_TOOL_TIP_TEXT);
                object = new BoldItalicChanger(n);
                this.bold[n] = new JToggleButton(SettingsEditorAction.BOLD_BUTTON_TOOL_TIP_TEXT, false);
                this.bold[n].setFont(font2);
                this.bold[n].addActionListener((ActionListener)object);
                this.bold[n].setToolTipText(SettingsEditorAction.BOLD_TOOL_TIP_TEXT);
                this.italic[n] = new JToggleButton(SettingsEditorAction.ITALIC_BUTTON_TOOL_TIP_TEXT, false);
                this.italic[n].setFont(font3);
                this.italic[n].addActionListener((ActionListener)object);
                this.italic[n].setToolTipText(SettingsEditorAction.ITALIC_TOOL_TIP_TEXT);
                stringArray3[n] = stringArray[jPanel2];
                this.useDefault[n] = new JCheckBox();
                this.useDefault[n].addItemListener(new DefaultChanger(n));
                this.useDefault[n].setToolTipText(SettingsEditorAction.DEFAULT_TOOL_TIP_TEXT);
                ++n;
            }
            this.initializeSyntaxStyleChangeables();
            jPanel.setLayout(new BorderLayout());
            JPanel jPanel2 = new JPanel(new GridLayout(this.syntaxStyleIndex.length, 2, 2, 2));
            object = new JPanel(new GridLayout(this.syntaxStyleIndex.length, 4, 2, 2));
            for (int jPanel3 = 0; jPanel3 < this.syntaxStyleIndex.length; ++jPanel3) {
                jPanel2.add(new JLabel(stringArray3[jPanel3], 4));
                jPanel2.add(this.samples[jPanel3]);
                ((Container)object).add(this.foregroundButtons[jPanel3]);
                ((Container)object).add(this.bold[jPanel3]);
                ((Container)object).add(this.italic[jPanel3]);
                ((Container)object).add(this.useDefault[jPanel3]);
            }
            JPanel jPanel3 = new JPanel(new FlowLayout(1));
            JCheckBox jCheckBox = new JCheckBox(){

                @Override
                protected void processMouseEvent(MouseEvent mouseEvent) {
                }

                @Override
                protected void processKeyEvent(KeyEvent keyEvent) {
                }
            };
            jCheckBox.setSelected(true);
            jPanel3.add(jCheckBox);
            jPanel3.add(new JLabel("= use defaults (disables buttons)"));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            jPanel.add((Component)jPanel3, "North");
            jPanel.add((Component)jPanel2, "West");
            jPanel.add((Component)object, "Center");
            return jPanel;
        }

        private void initializeSyntaxStyleChangeables() {
            for (int i = 0; i < this.samples.length; ++i) {
                Font font;
                int n = this.syntaxStyleIndex[i];
                this.samples[i].setFont(this.previewFont);
                this.samples[i].setForeground(this.initialStyles[n].getColor());
                this.foregroundButtons[i].setBackground(this.initialStyles[n].getColor());
                this.foregroundButtons[i].setEnabled(true);
                this.currentStyles[i] = this.initialStyles[n];
                this.bold[i].setSelected(this.initialStyles[n].isBold());
                if (this.bold[i].isSelected()) {
                    font = this.samples[i].getFont();
                    this.samples[i].setFont(font.deriveFont(font.getStyle() ^ 1));
                }
                this.italic[i].setSelected(this.initialStyles[n].isItalic());
                if (this.italic[i].isSelected()) {
                    font = this.samples[i].getFont();
                    this.samples[i].setFont(font.deriveFont(font.getStyle() ^ 2));
                }
                this.useDefault[i].setSelected(this.initialStyles[n].toString().equals(this.defaultStyles[n].toString()));
                if (!this.useDefault[i].isSelected()) continue;
                this.foregroundButtons[i].setEnabled(false);
                this.bold[i].setEnabled(false);
                this.italic[i].setEnabled(false);
            }
        }

        private void setSampleStyles(JLabel jLabel, SyntaxStyle syntaxStyle) {
            Font font = this.previewFont;
            if (syntaxStyle.isBold()) {
                font = font.deriveFont(font.getStyle() ^ 1);
            }
            if (syntaxStyle.isItalic()) {
                font = font.deriveFont(font.getStyle() ^ 2);
            }
            jLabel.setFont(font);
            jLabel.setForeground(syntaxStyle.getColor());
        }

        private class DefaultChanger
        implements ItemListener {
            private int row;

            public DefaultChanger(int n) {
                this.row = n;
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    EditorFontDialog.this.foregroundButtons[this.row].setEnabled(false);
                    EditorFontDialog.this.bold[this.row].setEnabled(false);
                    EditorFontDialog.this.italic[this.row].setEnabled(false);
                    ((EditorFontDialog)EditorFontDialog.this).currentStyles[this.row] = new SyntaxStyle(EditorFontDialog.this.foregroundButtons[this.row].getBackground(), EditorFontDialog.this.italic[this.row].isSelected(), EditorFontDialog.this.bold[this.row].isSelected());
                    SyntaxStyle syntaxStyle = EditorFontDialog.this.defaultStyles[EditorFontDialog.this.syntaxStyleIndex[this.row]];
                    EditorFontDialog.this.setSampleStyles(EditorFontDialog.this.samples[this.row], syntaxStyle);
                    EditorFontDialog.this.foregroundButtons[this.row].setBackground(syntaxStyle.getColor());
                    EditorFontDialog.this.bold[this.row].setSelected(syntaxStyle.isBold());
                    EditorFontDialog.this.italic[this.row].setSelected(syntaxStyle.isItalic());
                } else {
                    EditorFontDialog.this.setSampleStyles(EditorFontDialog.this.samples[this.row], EditorFontDialog.this.currentStyles[this.row]);
                    EditorFontDialog.this.foregroundButtons[this.row].setBackground(EditorFontDialog.this.currentStyles[this.row].getColor());
                    EditorFontDialog.this.bold[this.row].setSelected(EditorFontDialog.this.currentStyles[this.row].isBold());
                    EditorFontDialog.this.italic[this.row].setSelected(EditorFontDialog.this.currentStyles[this.row].isItalic());
                    EditorFontDialog.this.foregroundButtons[this.row].setEnabled(true);
                    EditorFontDialog.this.bold[this.row].setEnabled(true);
                    EditorFontDialog.this.italic[this.row].setEnabled(true);
                }
                EditorFontDialog.this.syntaxStylesAction = true;
            }
        }

        private class ForegroundChanger
        implements ActionListener {
            private int row;

            public ForegroundChanger(int n) {
                this.row = n;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = (JButton)actionEvent.getSource();
                Color color = JColorChooser.showDialog(null, "Set Text Color", jButton.getBackground());
                if (color != null) {
                    jButton.setBackground(color);
                    EditorFontDialog.this.samples[this.row].setForeground(color);
                }
                ((EditorFontDialog)EditorFontDialog.this).currentStyles[this.row] = new SyntaxStyle(jButton.getBackground(), EditorFontDialog.this.italic[this.row].isSelected(), EditorFontDialog.this.bold[this.row].isSelected());
                EditorFontDialog.this.syntaxStylesAction = true;
            }
        }

        private class BoldItalicChanger
        implements ActionListener {
            private int row;

            public BoldItalicChanger(int n) {
                this.row = n;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Font font = EditorFontDialog.this.samples[this.row].getFont();
                if (actionEvent.getActionCommand() == SettingsEditorAction.BOLD_BUTTON_TOOL_TIP_TEXT) {
                    if (EditorFontDialog.this.bold[this.row].isSelected()) {
                        EditorFontDialog.this.samples[this.row].setFont(font.deriveFont(font.getStyle() | 1));
                    } else {
                        EditorFontDialog.this.samples[this.row].setFont(font.deriveFont(font.getStyle() ^ 1));
                    }
                } else if (EditorFontDialog.this.italic[this.row].isSelected()) {
                    EditorFontDialog.this.samples[this.row].setFont(font.deriveFont(font.getStyle() | 2));
                } else {
                    EditorFontDialog.this.samples[this.row].setFont(font.deriveFont(font.getStyle() ^ 2));
                }
                ((EditorFontDialog)EditorFontDialog.this).currentStyles[this.row] = new SyntaxStyle(EditorFontDialog.this.foregroundButtons[this.row].getBackground(), EditorFontDialog.this.italic[this.row].isSelected(), EditorFontDialog.this.bold[this.row].isSelected());
                EditorFontDialog.this.syntaxStylesAction = true;
            }
        }
    }
}

