/*
 * Decompiled with CFR 0.152.
 */
package rars.assembler;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import rars.AssemblyException;
import rars.ErrorList;
import rars.ErrorMessage;
import rars.Globals;
import rars.RISCVprogram;
import rars.assembler.Directives;
import rars.assembler.SourceLine;
import rars.assembler.Token;
import rars.assembler.TokenList;
import rars.assembler.TokenTypes;

public class Tokenizer {
    private ErrorList errors = new ErrorList();
    private RISCVprogram sourceRISCVprogram;
    private HashMap<String, String> equivalents;
    private static final String escapedCharacters = "'\"\\ntbrf0";
    private static final String[] escapedCharactersValues = new String[]{"39", "34", "92", "10", "9", "8", "13", "12", "0"};

    public Tokenizer() {
        this(null);
    }

    public Tokenizer(RISCVprogram rISCVprogram) {
        this.sourceRISCVprogram = rISCVprogram;
    }

    public ArrayList<TokenList> tokenize(RISCVprogram rISCVprogram) throws AssemblyException {
        this.sourceRISCVprogram = rISCVprogram;
        this.equivalents = new HashMap();
        ArrayList<TokenList> arrayList = new ArrayList<TokenList>();
        ArrayList<SourceLine> arrayList2 = this.processIncludes(rISCVprogram, new HashMap<String, String>());
        rISCVprogram.setSourceLineList(arrayList2);
        for (int i = 0; i < arrayList2.size(); ++i) {
            String string = arrayList2.get(i).getSource();
            TokenList tokenList = this.tokenizeLine(i + 1, string);
            arrayList.add(tokenList);
            if (string.length() <= 0 || string == tokenList.getProcessedLine()) continue;
            arrayList2.set(i, new SourceLine(tokenList.getProcessedLine(), arrayList2.get(i).getRISCVprogram(), arrayList2.get(i).getLineNumber()));
        }
        if (this.errors.errorsOccurred()) {
            throw new AssemblyException(this.errors);
        }
        return arrayList;
    }

    private ArrayList<SourceLine> processIncludes(RISCVprogram rISCVprogram, Map<String, String> map) throws AssemblyException {
        ArrayList<String> arrayList = rISCVprogram.getSourceList();
        ArrayList<SourceLine> arrayList2 = new ArrayList<SourceLine>(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = arrayList.get(i);
            TokenList tokenList = this.tokenizeLine(rISCVprogram, i + 1, string, false);
            boolean bl = false;
            for (int j = 0; j < tokenList.size(); ++j) {
                Object object;
                if (!tokenList.get(j).getValue().equalsIgnoreCase(Directives.INCLUDE.getName()) || tokenList.size() <= j + 1 || tokenList.get(j + 1).getType() != TokenTypes.QUOTED_STRING) continue;
                String string2 = tokenList.get(j + 1).getValue();
                if (!new File(string2 = string2.substring(1, string2.length() - 1)).isAbsolute()) {
                    string2 = new File(rISCVprogram.getFilename()).getParent() + File.separator + string2;
                }
                if (map.containsKey(string2)) {
                    object = tokenList.get(j + 1);
                    this.errors.add(new ErrorMessage(rISCVprogram, ((Token)object).getSourceLine(), ((Token)object).getStartPos(), "Recursive include of file " + string2));
                    throw new AssemblyException(this.errors);
                }
                map.put(string2, string2);
                object = new RISCVprogram();
                try {
                    ((RISCVprogram)object).readSource(string2);
                }
                catch (AssemblyException assemblyException) {
                    Token token = tokenList.get(j + 1);
                    this.errors.add(new ErrorMessage(rISCVprogram, token.getSourceLine(), token.getStartPos(), "Error reading include file " + string2));
                    throw new AssemblyException(this.errors);
                }
                ArrayList<SourceLine> arrayList3 = this.processIncludes((RISCVprogram)object, map);
                arrayList2.addAll(arrayList3);
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList2.add(new SourceLine(string, rISCVprogram, i + 1));
        }
        return arrayList2;
    }

    public TokenList tokenizeExampleInstruction(String string) throws AssemblyException {
        TokenList tokenList = this.tokenizeLine(this.sourceRISCVprogram, 0, string, false);
        if (this.errors.errorsOccurred()) {
            throw new AssemblyException(this.errors);
        }
        return tokenList;
    }

    public TokenList tokenizeLine(int n, String string) {
        return this.tokenizeLine(this.sourceRISCVprogram, n, string, true);
    }

    public TokenList tokenizeLine(int n, String string, ErrorList errorList) {
        ErrorList errorList2 = this.errors;
        this.errors = errorList;
        TokenList tokenList = this.tokenizeLine(n, string);
        this.errors = errorList2;
        return tokenList;
    }

    public TokenList tokenizeLine(int n, String string, ErrorList errorList, boolean bl) {
        ErrorList errorList2 = this.errors;
        this.errors = errorList;
        TokenList tokenList = this.tokenizeLine(this.sourceRISCVprogram, n, string, bl);
        this.errors = errorList2;
        return tokenList;
    }

    public TokenList tokenizeLine(RISCVprogram rISCVprogram, int n, String string, boolean bl) {
        TokenList tokenList = new TokenList();
        if (string.length() == 0) {
            return tokenList;
        }
        char[] cArray = string.toCharArray();
        int n2 = 0;
        char[] cArray2 = new char[cArray.length];
        int n3 = 0;
        int n4 = 1;
        boolean bl2 = false;
        if (Globals.debug) {
            System.out.println("source line --->" + string + "<---");
        }
        while (n2 < cArray.length) {
            char c = cArray[n2];
            if (bl2) {
                cArray2[n3++] = c;
                if (c == '\"' && cArray2[n3 - 2] != '\\') {
                    this.processCandidateToken(cArray2, rISCVprogram, n, string, n3, n4, tokenList);
                    n3 = 0;
                    bl2 = false;
                }
            } else {
                switch (c) {
                    case '#': {
                        if (n3 > 0) {
                            this.processCandidateToken(cArray2, rISCVprogram, n, string, n3, n4, tokenList);
                        }
                        n4 = n2 + 1;
                        n3 = cArray.length - n2;
                        System.arraycopy(cArray, n2, cArray2, 0, n3);
                        this.processCandidateToken(cArray2, rISCVprogram, n, string, n3, n4, tokenList);
                        n2 = cArray.length;
                        n3 = 0;
                        break;
                    }
                    case '\t': 
                    case ' ': 
                    case ',': {
                        if (n3 <= 0) break;
                        this.processCandidateToken(cArray2, rISCVprogram, n, string, n3, n4, tokenList);
                        n3 = 0;
                        break;
                    }
                    case '+': 
                    case '-': {
                        if (n3 > 0 && cArray.length >= n2 + 2 && Character.isDigit(cArray[n2 + 1]) && (cArray[n2 - 1] == 'e' || cArray[n2 - 1] == 'E')) {
                            cArray2[n3++] = c;
                            break;
                        }
                        if (n3 > 0) {
                            this.processCandidateToken(cArray2, rISCVprogram, n, string, n3, n4, tokenList);
                            n3 = 0;
                        }
                        n4 = n2 + 1;
                        cArray2[n3++] = c;
                        if (cArray.length > n2 + 3 && cArray[n2 + 1] == 'I' && cArray[n2 + 2] == 'n' && cArray[n2 + 3] == 'f') {
                            tokenList.add(new Token(TokenTypes.REAL_NUMBER, "-Inf", rISCVprogram, n, n4));
                            n2 += 3;
                            n3 = 0;
                            break;
                        }
                        if ((tokenList.isEmpty() || tokenList.get(tokenList.size() - 1).getType() != TokenTypes.IDENTIFIER) && cArray.length >= n2 + 2 && Character.isDigit(cArray[n2 + 1])) break;
                        this.processCandidateToken(cArray2, rISCVprogram, n, string, n3, n4, tokenList);
                        n3 = 0;
                        break;
                    }
                    case '(': 
                    case ')': 
                    case ':': {
                        if (n3 > 0) {
                            this.processCandidateToken(cArray2, rISCVprogram, n, string, n3, n4, tokenList);
                            n3 = 0;
                        }
                        n4 = n2 + 1;
                        cArray2[n3++] = c;
                        this.processCandidateToken(cArray2, rISCVprogram, n, string, n3, n4, tokenList);
                        n3 = 0;
                        break;
                    }
                    case '\"': {
                        if (n3 > 0) {
                            this.processCandidateToken(cArray2, rISCVprogram, n, string, n3, n4, tokenList);
                            n3 = 0;
                        }
                        n4 = n2 + 1;
                        cArray2[n3++] = c;
                        bl2 = true;
                        break;
                    }
                    case '\'': {
                        if (n3 > 0) {
                            this.processCandidateToken(cArray2, rISCVprogram, n, string, n3, n4, tokenList);
                            n3 = 0;
                        }
                        n4 = n2 + 1;
                        cArray2[n3++] = c;
                        int n5 = cArray.length - n2 - 1;
                        if (n5 < 2) break;
                        c = cArray[++n2];
                        cArray2[n3++] = c;
                        if (c == '\'') break;
                        c = cArray[++n2];
                        cArray2[n3++] = c;
                        if (c == '\'' && cArray2[1] != '\\' || n5 == 2) {
                            this.processCandidateToken(cArray2, rISCVprogram, n, string, n3, n4, tokenList);
                            n3 = 0;
                            n4 = n2 + 1;
                            break;
                        }
                        c = cArray[++n2];
                        cArray2[n3++] = c;
                        if (c == '\'' || n5 == 3) {
                            this.processCandidateToken(cArray2, rISCVprogram, n, string, n3, n4, tokenList);
                            n3 = 0;
                            n4 = n2 + 1;
                            break;
                        }
                        if (n5 >= 5) {
                            c = cArray[++n2];
                            cArray2[n3++] = c;
                            if (c != '\'') {
                                c = cArray[++n2];
                                cArray2[n3++] = c;
                            }
                        }
                        this.processCandidateToken(cArray2, rISCVprogram, n, string, n3, n4, tokenList);
                        n3 = 0;
                        n4 = n2 + 1;
                        break;
                    }
                    default: {
                        if (n3 == 0) {
                            n4 = n2 + 1;
                        }
                        cArray2[n3++] = c;
                    }
                }
            }
            ++n2;
        }
        if (n3 > 0) {
            if (bl2) {
                this.errors.add(new ErrorMessage(rISCVprogram, n, n4, "String is not terminated."));
            }
            this.processCandidateToken(cArray2, rISCVprogram, n, string, n3, n4, tokenList);
            n3 = 0;
        }
        if (bl) {
            tokenList = this.processEqv(rISCVprogram, n, string, tokenList);
        }
        return tokenList;
    }

    private TokenList processEqv(RISCVprogram rISCVprogram, int n, String string, TokenList tokenList) {
        int n2;
        if (tokenList.size() > 2 && (tokenList.get(0).getType() == TokenTypes.DIRECTIVE || tokenList.get(2).getType() == TokenTypes.DIRECTIVE)) {
            int n3 = n2 = tokenList.get(0).getType() == TokenTypes.DIRECTIVE ? 0 : 2;
            if (Directives.matchDirective(tokenList.get(n2).getValue()) == Directives.EQV) {
                int n4;
                int n5 = tokenList.size() - (tokenList.get(tokenList.size() - 1).getType() == TokenTypes.COMMENT ? 2 : 1);
                if (n5 < n2 + 2) {
                    this.errors.add(new ErrorMessage(rISCVprogram, n, tokenList.get(n2).getStartPos(), "Too few operands for " + Directives.EQV.getName() + " directive"));
                    return tokenList;
                }
                if (tokenList.get(n2 + 1).getType() != TokenTypes.IDENTIFIER) {
                    this.errors.add(new ErrorMessage(rISCVprogram, n, tokenList.get(n2).getStartPos(), "Malformed " + Directives.EQV.getName() + " directive"));
                    return tokenList;
                }
                String string2 = tokenList.get(n2 + 1).getValue();
                for (n4 = n2 + 2; n4 < tokenList.size(); ++n4) {
                    if (!tokenList.get(n4).getValue().equals(string2)) continue;
                    this.errors.add(new ErrorMessage(rISCVprogram, n, tokenList.get(n2).getStartPos(), "Cannot substitute " + string2 + " for itself in " + Directives.EQV.getName() + " directive"));
                    return tokenList;
                }
                n4 = tokenList.get(n2 + 2).getStartPos();
                int n6 = tokenList.get(n5).getStartPos() + tokenList.get(n5).getValue().length();
                String string3 = string.substring(n4 - 1, n6 - 1);
                if (this.equivalents.containsKey(string2) && !this.equivalents.get(string2).equals(string3)) {
                    this.errors.add(new ErrorMessage(rISCVprogram, n, tokenList.get(n2 + 1).getStartPos(), "\"" + string2 + "\" is already defined"));
                    return tokenList;
                }
                this.equivalents.put(string2, string3);
                return tokenList;
            }
        }
        n2 = 0;
        for (int i = 0; i < tokenList.size(); ++i) {
            Token token = tokenList.get(i);
            if (token.getType() != TokenTypes.IDENTIFIER || this.equivalents == null || !this.equivalents.containsKey(token.getValue())) continue;
            String string4 = this.equivalents.get(token.getValue());
            int n7 = token.getStartPos();
            string = string.substring(0, n7 - 1) + string4 + string.substring(n7 + token.getValue().length() - 1);
            n2 = 1;
            break;
        }
        tokenList.setProcessedLine(string);
        return n2 != 0 ? this.tokenizeLine(n, string) : tokenList;
    }

    public ErrorList getErrors() {
        return this.errors;
    }

    private void processCandidateToken(char[] cArray, RISCVprogram rISCVprogram, int n, String string, int n2, int n3, TokenList tokenList) {
        TokenTypes tokenTypes;
        String string2 = new String(cArray, 0, n2);
        if (string2.length() > 0 && string2.charAt(0) == '\'') {
            string2 = this.preprocessCharacterLiteral(string2);
        }
        if ((tokenTypes = TokenTypes.matchTokenType(string2)) == TokenTypes.ERROR) {
            this.errors.add(new ErrorMessage(rISCVprogram, n, n3, string + "\nInvalid language element: " + string2));
        }
        Token token = new Token(tokenTypes, string2, rISCVprogram, n, n3);
        tokenList.add(token);
    }

    private String preprocessCharacterLiteral(String string) {
        if (string.length() < 3 || string.charAt(0) != '\'' || string.charAt(string.length() - 1) != '\'') {
            return string;
        }
        String string2 = string.substring(1, string.length() - 1);
        if (string2.charAt(0) != '\\') {
            return string2.length() == 1 ? Integer.toString(string2.charAt(0)) : string;
        }
        if (string2.length() == 2) {
            int n = escapedCharacters.indexOf(string2.charAt(1));
            return n >= 0 ? escapedCharactersValues[n] : string;
        }
        if (string2.length() == 4) {
            try {
                int n = Integer.parseInt(string2.substring(1), 8);
                if (n >= 0 && n <= 255) {
                    return Integer.toString(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return string;
    }
}

