/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv;

import java.util.ArrayList;
import java.util.HashSet;
import rars.Globals;
import rars.riscv.AbstractSyscall;
import rars.riscv.SyscallNumberOverride;
import rars.util.FilenameFinder;

public class SyscallLoader {
    private static final String CLASS_PREFIX = "rars.riscv.syscalls.";
    private static final String SYSCALLS_DIRECTORY_PATH = "rars/riscv/syscalls";
    private static final String CLASS_EXTENSION = "class";
    private static ArrayList<AbstractSyscall> syscallList = new ArrayList();

    private static ArrayList<AbstractSyscall> processSyscallNumberOverrides(ArrayList<AbstractSyscall> arrayList) {
        ArrayList<SyscallNumberOverride> arrayList2 = new Globals().getSyscallOverrides();
        if (arrayList.size() != arrayList2.size()) {
            System.out.println("Error: the number of entries in the config file does not match the number of syscalls loaded");
            System.out.println("Ensure there is a Syscall.properties file in the directory you are executing if you are a developer");
            System.exit(0);
        }
        for (SyscallNumberOverride syscallNumberOverride : arrayList2) {
            boolean bl = false;
            for (AbstractSyscall abstractSyscall : arrayList) {
                if (abstractSyscall.getNumber() == syscallNumberOverride.getNumber()) {
                    System.out.println("Duplicate service number: " + abstractSyscall.getNumber() + " already registered to " + SyscallLoader.findSyscall(abstractSyscall.getNumber()).getName());
                    System.exit(0);
                }
                if (!syscallNumberOverride.getName().equals(abstractSyscall.getName())) continue;
                if (abstractSyscall.getNumber() != -1) {
                    System.out.println("Error: " + abstractSyscall.getName() + " was assigned a numebr twice in the config file");
                    System.exit(0);
                }
                if (syscallNumberOverride.getNumber() < 0) {
                    System.out.println("Error: " + syscallNumberOverride.getName() + " was assigned a negative number");
                    System.exit(0);
                }
                abstractSyscall.setNumber(syscallNumberOverride.getNumber());
                bl = true;
            }
            if (bl) continue;
            System.out.println("Error: syscall name '" + syscallNumberOverride.getName() + "' in config file does not match any name in syscall list");
            System.exit(0);
        }
        return arrayList;
    }

    public static AbstractSyscall findSyscall(int n) {
        for (AbstractSyscall abstractSyscall : syscallList) {
            if (abstractSyscall.getNumber() != n) continue;
            return abstractSyscall;
        }
        return null;
    }

    public static ArrayList<AbstractSyscall> getSyscallList() {
        return syscallList;
    }

    static {
        ArrayList<String> arrayList = FilenameFinder.getFilenameList(SyscallLoader.class.getClassLoader(), SYSCALLS_DIRECTORY_PATH, CLASS_EXTENSION);
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : arrayList) {
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
            try {
                String string2 = CLASS_PREFIX + string.substring(0, string.indexOf(CLASS_EXTENSION) - 1);
                Class<?> clazz = Class.forName(string2);
                if (!AbstractSyscall.class.isAssignableFrom(clazz)) continue;
                AbstractSyscall abstractSyscall = (AbstractSyscall)clazz.newInstance();
                if (abstractSyscall.getNumber() == -1) {
                    syscallList.add(abstractSyscall);
                    continue;
                }
                throw new Exception("Syscalls must assign -1 for number");
            }
            catch (Exception exception) {
                System.out.println("Error instantiating Syscall from file " + string + ": " + exception);
                System.exit(0);
            }
        }
        syscallList = SyscallLoader.processSyscallNumberOverrides(syscallList);
    }
}

