/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import jsoftfloat.Environment;
import jsoftfloat.types.Float32;
import jsoftfloat.types.Float64;
import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.instructions.Floating;

public class FCVTSD
extends BasicInstruction {
    public FCVTSD() {
        super("fcvt.s.d f1, f2, dyn", "Convert a double to a float: Assigned the value of f2 to f1", BasicInstructionFormat.R4_FORMAT, "0100000 00001 sssss ttt fffff 1010011");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        Environment environment = new Environment();
        environment.mode = Floating.getRoundingMode(nArray[2], programStatement);
        Float64 float64 = new Float64(FloatingPointRegisterFile.getValueLong(nArray[1]));
        Float32 float32 = new Float32(0);
        float32 = FCVTSD.convert(float64, float32, environment);
        Floating.setfflags(environment);
        FloatingPointRegisterFile.updateRegister(nArray[0], float32.bits);
    }

    public static <S extends jsoftfloat.types.Floating<S>, D extends jsoftfloat.types.Floating<D>> S convert(D d, S s, Environment environment) {
        if (d.isInfinite()) {
            return d.isSignMinus() ? s.NegativeInfinity() : s.Infinity();
        }
        if (d.isZero()) {
            return d.isSignMinus() ? s.NegativeZero() : s.Zero();
        }
        if (d.isNaN()) {
            return s.NaN();
        }
        return s.fromExactFloat(d.toExactFloat(), environment);
    }
}

