/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import rars.ProgramStatement;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.InstructionSet;
import rars.riscv.hardware.RegisterFile;

public abstract class ImmediateInstruction
extends BasicInstruction {
    public ImmediateInstruction(String string, String string2, String string3) {
        super(string, string2, BasicInstructionFormat.I_FORMAT, "tttttttttttt sssss " + string3 + " fffff 0010011");
    }

    public ImmediateInstruction(String string, String string2, String string3, boolean bl) {
        super(string, string2, BasicInstructionFormat.I_FORMAT, "tttttttttttt sssss " + string3 + " fffff 0011011", bl);
    }

    @Override
    public void simulate(ProgramStatement programStatement) {
        int[] nArray = programStatement.getOperands();
        if (InstructionSet.rv64) {
            RegisterFile.updateRegister(nArray[0], this.compute(RegisterFile.getValueLong(nArray[1]), nArray[2] << 20 >> 20));
        } else {
            RegisterFile.updateRegister(nArray[0], (long)this.computeW(RegisterFile.getValue(nArray[1]), nArray[2] << 20 >> 20));
        }
    }

    protected abstract long compute(long var1, long var3);

    protected int computeW(int n, int n2) {
        return (int)this.compute(n, n2);
    }
}

