/*
 * Decompiled with CFR 0.152.
 */
package rars.tools;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import rars.ProgramStatement;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.AccessNotice;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.MemoryAccessNotice;
import rars.tools.AbstractToolAndApplication;

public class InstructionCounter
extends AbstractToolAndApplication {
    private static String name = "Instruction Counter";
    private static String version = "Version 1.0 (Felipe Lessa)";
    private static String heading = "Counting the number of instructions executed";
    private int counter = 0;
    private JTextField counterField;
    private int counterR = 0;
    private JTextField counterRField;
    private JProgressBar progressbarR;
    private int counterR4 = 0;
    private JTextField counterR4Field;
    private JProgressBar progressbarR4;
    private int counterI = 0;
    private JTextField counterIField;
    private JProgressBar progressbarI;
    private int counterS = 0;
    private JTextField counterSField;
    private JProgressBar progressbarS;
    private int counterB = 0;
    private JTextField counterBField;
    private JProgressBar progressbarB;
    private int counterU = 0;
    private JTextField counterUField;
    private JProgressBar progressbarU;
    private int counterJ = 0;
    private JTextField counterJField;
    private JProgressBar progressbarJ;
    private int lastAddress = -1;

    public InstructionCounter(String string, String string2) {
        super(string, string2);
    }

    public InstructionCounter() {
        super(name + ", " + version, heading);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    protected JComponent buildMainDisplayArea() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.counterField = new JTextField("0", 10);
        this.counterField.setEditable(false);
        this.counterRField = new JTextField("0", 10);
        this.counterRField.setEditable(false);
        this.progressbarR = new JProgressBar(0);
        this.progressbarR.setStringPainted(true);
        this.counterR4Field = new JTextField("0", 10);
        this.counterR4Field.setEditable(false);
        this.progressbarR4 = new JProgressBar(0);
        this.progressbarR4.setStringPainted(true);
        this.counterIField = new JTextField("0", 10);
        this.counterIField.setEditable(false);
        this.progressbarI = new JProgressBar(0);
        this.progressbarI.setStringPainted(true);
        this.counterSField = new JTextField("0", 10);
        this.counterSField.setEditable(false);
        this.progressbarS = new JProgressBar(0);
        this.progressbarS.setStringPainted(true);
        this.counterBField = new JTextField("0", 10);
        this.counterBField.setEditable(false);
        this.progressbarB = new JProgressBar(0);
        this.progressbarB.setStringPainted(true);
        this.counterUField = new JTextField("0", 10);
        this.counterUField.setEditable(false);
        this.progressbarU = new JProgressBar(0);
        this.progressbarU.setStringPainted(true);
        this.counterJField = new JTextField("0", 10);
        this.counterJField.setEditable(false);
        this.progressbarJ = new JProgressBar(0);
        this.progressbarJ.setStringPainted(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 17, 0);
        jPanel.add((Component)this.counterField, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.counterRField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.counterR4Field, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.counterIField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.counterSField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.counterBField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.counterUField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.counterJField, gridBagConstraints);
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 17, 0);
        jPanel.add((Component)new JLabel("Instructions so far: "), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("R-type: "), gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("R4-type: "), gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("I-type: "), gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("S-type: "), gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("B-type: "), gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("U-type: "), gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("J-type: "), gridBagConstraints);
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.progressbarR, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.progressbarR4, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.progressbarI, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.progressbarS, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.progressbarB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.progressbarU, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.progressbarJ, gridBagConstraints);
        return jPanel;
    }

    @Override
    protected void addAsObserver() {
        this.addAsObserver(Memory.textBaseAddress, Memory.textLimitAddress);
    }

    @Override
    protected void processRISCVUpdate(Observable observable, AccessNotice accessNotice) {
        if (!accessNotice.accessIsFromRISCV()) {
            return;
        }
        if (accessNotice.getAccessType() != 0) {
            return;
        }
        MemoryAccessNotice memoryAccessNotice = (MemoryAccessNotice)accessNotice;
        int n = memoryAccessNotice.getAddress();
        if (n == this.lastAddress) {
            return;
        }
        this.lastAddress = n;
        ++this.counter;
        try {
            ProgramStatement programStatement = Memory.getInstance().getStatement(n);
            if (programStatement != null) {
                BasicInstruction basicInstruction = (BasicInstruction)programStatement.getInstruction();
                BasicInstructionFormat basicInstructionFormat = basicInstruction.getInstructionFormat();
                if (basicInstructionFormat == BasicInstructionFormat.R_FORMAT) {
                    ++this.counterR;
                } else if (basicInstructionFormat == BasicInstructionFormat.R4_FORMAT) {
                    ++this.counterR4;
                } else if (basicInstructionFormat == BasicInstructionFormat.I_FORMAT) {
                    ++this.counterI;
                } else if (basicInstructionFormat == BasicInstructionFormat.S_FORMAT) {
                    ++this.counterS;
                } else if (basicInstructionFormat == BasicInstructionFormat.B_FORMAT) {
                    ++this.counterB;
                } else if (basicInstructionFormat == BasicInstructionFormat.U_FORMAT) {
                    ++this.counterU;
                } else if (basicInstructionFormat == BasicInstructionFormat.J_FORMAT) {
                    ++this.counterJ;
                }
            }
        }
        catch (AddressErrorException addressErrorException) {
            addressErrorException.printStackTrace();
        }
        this.updateDisplay();
    }

    @Override
    protected void initializePreGUI() {
        this.counterJ = 0;
        this.counterU = 0;
        this.counterB = 0;
        this.counterS = 0;
        this.counterI = 0;
        this.counterR4 = 0;
        this.counterR = 0;
        this.counter = 0;
        this.lastAddress = -1;
    }

    @Override
    protected void reset() {
        this.counterJ = 0;
        this.counterU = 0;
        this.counterB = 0;
        this.counterS = 0;
        this.counterI = 0;
        this.counterR4 = 0;
        this.counterR = 0;
        this.counter = 0;
        this.lastAddress = -1;
        this.updateDisplay();
    }

    @Override
    protected void updateDisplay() {
        this.counterField.setText(String.valueOf(this.counter));
        this.counterRField.setText(String.valueOf(this.counterR));
        this.progressbarR.setMaximum(this.counter);
        this.progressbarR.setValue(this.counterR);
        this.counterR4Field.setText(String.valueOf(this.counterR4));
        this.progressbarR4.setMaximum(this.counter);
        this.progressbarR4.setValue(this.counterR4);
        this.counterIField.setText(String.valueOf(this.counterI));
        this.progressbarI.setMaximum(this.counter);
        this.progressbarI.setValue(this.counterI);
        this.counterSField.setText(String.valueOf(this.counterS));
        this.progressbarS.setMaximum(this.counter);
        this.progressbarS.setValue(this.counterS);
        this.counterBField.setText(String.valueOf(this.counterB));
        this.progressbarB.setMaximum(this.counter);
        this.progressbarB.setValue(this.counterB);
        this.counterUField.setText(String.valueOf(this.counterU));
        this.progressbarU.setMaximum(this.counter);
        this.progressbarU.setValue(this.counterU);
        this.counterJField.setText(String.valueOf(this.counterJ));
        this.progressbarJ.setMaximum(this.counter);
        this.progressbarJ.setValue(this.counterJ);
        if (this.counter == 0) {
            this.progressbarR.setString("0%");
            this.progressbarR4.setString("0%");
            this.progressbarI.setString("0%");
            this.progressbarS.setString("0%");
            this.progressbarB.setString("0%");
            this.progressbarU.setString("0%");
            this.progressbarJ.setString("0%");
        } else {
            this.progressbarR.setString(this.counterR * 100 / this.counter + "%");
            this.progressbarR4.setString(this.counterR4 * 100 / this.counter + "%");
            this.progressbarI.setString(this.counterI * 100 / this.counter + "%");
            this.progressbarS.setString(this.counterS * 100 / this.counter + "%");
            this.progressbarB.setString(this.counterB * 100 / this.counter + "%");
            this.progressbarU.setString(this.counterU * 100 / this.counter + "%");
            this.progressbarJ.setString(this.counterJ * 100 / this.counter + "%");
        }
    }
}

