/*
 * Decompiled with CFR 0.152.
 */
package rars.tools;

import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Observable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import rars.ProgramStatement;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.AccessNotice;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.MemoryAccessNotice;
import rars.tools.AbstractToolAndApplication;

public class InstructionMemoryDump
extends AbstractToolAndApplication {
    private static String name = "Instruction/Memory Dump";
    private static String version = "Version 1.0 (John Owens)";
    private static String heading = "Dumps every executed instruction and data memory access to a file";
    private int lastAddress = -1;
    private StringBuffer log = new StringBuffer("");
    private JTextField dumpLogFilename;
    private JLabel logSuccess;
    private int lowDataSegmentAddress = Memory.dataSegmentBaseAddress;
    private int highDataSegmentAddress = Memory.stackBaseAddress;

    public InstructionMemoryDump(String string, String string2) {
        super(string, string2);
    }

    public InstructionMemoryDump() {
        super(name + ", " + version, heading);
    }

    @Override
    protected JComponent buildMainDisplayArea() {
        JPanel jPanel = new JPanel(new FlowLayout());
        JButton jButton = new JButton("Dump Log");
        jButton.setToolTipText("Dumps the log to a file");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InstructionMemoryDump.this.dumpLog();
            }
        });
        jButton.addKeyListener(new AbstractToolAndApplication.EnterKeyListener(this, jButton));
        this.dumpLogFilename = new JTextField("dumplog.txt", 20);
        jPanel.add(jButton);
        jPanel.add(this.dumpLogFilename);
        this.logSuccess = new JLabel("");
        this.logSuccess.setFont(new Font("Monospaced", 0, 12));
        this.logSuccess.setFocusable(false);
        this.logSuccess.setBackground(jPanel.getBackground());
        jPanel.add(this.logSuccess);
        return jPanel;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    protected void addAsObserver() {
        this.addAsObserver(Memory.textBaseAddress, Memory.textLimitAddress);
        this.addAsObserver(this.lowDataSegmentAddress, this.highDataSegmentAddress);
    }

    @Override
    protected void processRISCVUpdate(Observable observable, AccessNotice accessNotice) {
        if (!accessNotice.accessIsFromRISCV()) {
            return;
        }
        MemoryAccessNotice memoryAccessNotice = (MemoryAccessNotice)accessNotice;
        int n = memoryAccessNotice.getAddress();
        if (n >= Memory.textBaseAddress && n < Memory.textLimitAddress) {
            if (accessNotice.getAccessType() != 0) {
                return;
            }
            if (n == this.lastAddress) {
                return;
            }
            this.lastAddress = n;
            try {
                ProgramStatement programStatement = Memory.getInstance().getStatement(n);
                if (programStatement != null) {
                    BasicInstruction basicInstruction = (BasicInstruction)programStatement.getInstruction();
                    BasicInstructionFormat basicInstructionFormat = basicInstruction.getInstructionFormat();
                    this.log.append("I: 0x" + Integer.toUnsignedString(n, 16) + "\n");
                    this.log.append("i: 0x" + Integer.toUnsignedString(programStatement.getBinaryStatement(), 16) + "\n");
                }
            }
            catch (AddressErrorException addressErrorException) {
                addressErrorException.printStackTrace();
            }
        }
        if (n >= this.lowDataSegmentAddress && n < this.highDataSegmentAddress) {
            if (accessNotice.getAccessType() == 0) {
                this.log.append("L: 0x");
            }
            if (accessNotice.getAccessType() == 1) {
                this.log.append("S: 0x");
            }
            this.log.append(Integer.toUnsignedString(n, 16) + "\n");
        }
        this.updateDisplay();
    }

    @Override
    protected void initializePreGUI() {
    }

    public void dumpLog() {
        try {
            String string = this.dumpLogFilename.getText();
            if (string.equals("")) {
                this.logSuccess.setText("Enter a filename before trying to dump log");
                return;
            }
            File file = new File(string);
            String string2 = file.getCanonicalPath();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(this.log.toString());
            bufferedWriter.flush();
            bufferedWriter.close();
            this.logSuccess.setText("Successfully dumped to " + string2);
        }
        catch (IOException iOException) {
            this.logSuccess.setText("Failed to successfully dump. Cause: " + iOException.getMessage());
        }
        this.theWindow.pack();
    }

    @Override
    protected void reset() {
        this.lastAddress = -1;
        this.logSuccess.setText("");
        this.updateDisplay();
    }

    @Override
    protected void updateDisplay() {
    }

    @Override
    protected JComponent getHelpComponent() {
        JButton jButton = new JButton("Help");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTextArea jTextArea = new JTextArea(" Generates a trace, to be stored in a file specified by the user, with one line per datum. The four kinds of data in the trace are: \n  - I: The address of an access into instruction memory \n  - i: A 32-bit RISC-V instruction (the trace first dumps the address then the instruction)\n  - L: The address of a memory load into data memory\n  - S: The address of a memory store into data memory (the contents of the memory load/store aren\u2019t in the trace)\n");
                jTextArea.setRows(20);
                jTextArea.setColumns(60);
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                JOptionPane.showMessageDialog(InstructionMemoryDump.this.theWindow, new JScrollPane(jTextArea), "Log format", 1);
            }
        });
        return jButton;
    }
}

