/*
 * Decompiled with CFR 0.152.
 */
package rars.tools;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import rars.ProgramStatement;
import rars.riscv.Instruction;
import rars.riscv.hardware.AccessNotice;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.MemoryAccessNotice;
import rars.riscv.instructions.ADDI;
import rars.riscv.instructions.ADDIW;
import rars.riscv.instructions.ANDI;
import rars.riscv.instructions.AUIPC;
import rars.riscv.instructions.Arithmetic;
import rars.riscv.instructions.Branch;
import rars.riscv.instructions.JAL;
import rars.riscv.instructions.JALR;
import rars.riscv.instructions.LUI;
import rars.riscv.instructions.Load;
import rars.riscv.instructions.ORI;
import rars.riscv.instructions.SLLI;
import rars.riscv.instructions.SLLI64;
import rars.riscv.instructions.SLLIW;
import rars.riscv.instructions.SLTI;
import rars.riscv.instructions.SLTIU;
import rars.riscv.instructions.SRAI;
import rars.riscv.instructions.SRAI64;
import rars.riscv.instructions.SRAIW;
import rars.riscv.instructions.SRLI;
import rars.riscv.instructions.SRLI64;
import rars.riscv.instructions.SRLIW;
import rars.riscv.instructions.Store;
import rars.riscv.instructions.XORI;
import rars.tools.AbstractToolAndApplication;

public class InstructionStatistics
extends AbstractToolAndApplication {
    private static String NAME = "Instruction Statistics";
    private static String VERSION = "Version 1.0 (Ingo Kofler)";
    private static String HEADING = "";
    private static final int MAX_CATEGORY = 5;
    private static final int CATEGORY_ALU = 0;
    private static final int CATEGORY_JUMP = 1;
    private static final int CATEGORY_BRANCH = 2;
    private static final int CATEGORY_MEM = 3;
    private static final int CATEGORY_OTHER = 4;
    private JTextField m_tfTotalCounter;
    private JTextField[] m_tfCounters;
    private JProgressBar[] m_pbCounters;
    private int m_totalCounter = 0;
    private int[] m_counters = new int[5];
    private String[] m_categoryLabels = new String[]{"ALU", "Jump", "Branch", "Memory", "Other"};
    protected int lastAddress = -1;

    public InstructionStatistics(String string, String string2) {
        super(string, string2);
    }

    public InstructionStatistics() {
        super(NAME + ", " + VERSION, HEADING);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected JComponent buildMainDisplayArea() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.m_tfTotalCounter = new JTextField("0", 10);
        this.m_tfTotalCounter.setEditable(false);
        this.m_tfCounters = new JTextField[5];
        this.m_pbCounters = new JProgressBar[5];
        for (int i = 0; i < 5; ++i) {
            this.m_tfCounters[i] = new JTextField("0", 10);
            this.m_tfCounters[i].setEditable(false);
            this.m_pbCounters[i] = new JProgressBar(0);
            this.m_pbCounters[i].setStringPainted(true);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 17, 0);
        jPanel.add((Component)new JLabel("Total: "), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)this.m_tfTotalCounter, gridBagConstraints);
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        for (int i = 0; i < 5; ++i) {
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 2;
            jPanel.add((Component)new JLabel(this.m_categoryLabels[i] + ":   "), gridBagConstraints);
            gridBagConstraints.gridx = 3;
            jPanel.add((Component)this.m_tfCounters[i], gridBagConstraints);
            gridBagConstraints.gridx = 4;
            jPanel.add((Component)this.m_pbCounters[i], gridBagConstraints);
        }
        return jPanel;
    }

    @Override
    protected void addAsObserver() {
        this.addAsObserver(Memory.textBaseAddress, Memory.textLimitAddress);
    }

    protected int getInstructionCategory(Instruction instruction) {
        if (instruction instanceof Arithmetic) {
            return 0;
        }
        if (instruction instanceof ADDI || instruction instanceof ADDIW || instruction instanceof ANDI || instruction instanceof ORI || instruction instanceof XORI || instruction instanceof SLTI || instruction instanceof SLTIU || instruction instanceof LUI || instruction instanceof AUIPC) {
            return 0;
        }
        if (instruction instanceof SLLI || instruction instanceof SLLI64 || instruction instanceof SLLIW) {
            return 0;
        }
        if (instruction instanceof SRLI || instruction instanceof SRLI64 || instruction instanceof SRLIW) {
            return 0;
        }
        if (instruction instanceof SRAI || instruction instanceof SRAI64 || instruction instanceof SRAIW) {
            return 0;
        }
        if (instruction instanceof JAL || instruction instanceof JALR) {
            return 1;
        }
        if (instruction instanceof Branch) {
            return 2;
        }
        if (instruction instanceof Load) {
            return 3;
        }
        if (instruction instanceof Store) {
            return 3;
        }
        return 4;
    }

    @Override
    protected void processRISCVUpdate(Observable observable, AccessNotice accessNotice) {
        if (!accessNotice.accessIsFromRISCV()) {
            return;
        }
        if (accessNotice.getAccessType() == 0 && accessNotice instanceof MemoryAccessNotice) {
            MemoryAccessNotice memoryAccessNotice = (MemoryAccessNotice)accessNotice;
            int n = memoryAccessNotice.getAddress();
            if (n == this.lastAddress) {
                return;
            }
            this.lastAddress = n;
            try {
                ProgramStatement programStatement = Memory.getInstance().getStatementNoNotify(memoryAccessNotice.getAddress());
                if (programStatement != null) {
                    int n2 = this.getInstructionCategory(programStatement.getInstruction());
                    ++this.m_totalCounter;
                    int n3 = n2;
                    this.m_counters[n3] = this.m_counters[n3] + 1;
                    this.updateDisplay();
                }
            }
            catch (AddressErrorException addressErrorException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void initializePreGUI() {
        this.m_totalCounter = 0;
        this.lastAddress = -1;
        for (int i = 0; i < 5; ++i) {
            this.m_counters[i] = 0;
        }
    }

    @Override
    protected void reset() {
        this.m_totalCounter = 0;
        this.lastAddress = -1;
        for (int i = 0; i < 5; ++i) {
            this.m_counters[i] = 0;
        }
        this.updateDisplay();
    }

    @Override
    protected void updateDisplay() {
        this.m_tfTotalCounter.setText(String.valueOf(this.m_totalCounter));
        for (int i = 0; i < 5; ++i) {
            this.m_tfCounters[i].setText(String.valueOf(this.m_counters[i]));
            this.m_pbCounters[i].setMaximum(this.m_totalCounter);
            this.m_pbCounters[i].setValue(this.m_counters[i]);
        }
    }
}

