/*
 * Decompiled with CFR 0.152.
 */
package rars.venus;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import rars.Globals;
import rars.venus.EditPane;
import rars.venus.GuiAction;
import rars.venus.MainPane;
import rars.venus.VenusUI;

public class EditFindReplaceAction
extends GuiAction {
    private static String searchString = "";
    private static boolean caseSensitivity = true;
    private static final String DIALOG_TITLE = "Find and Replace";
    private MainPane mainPane;
    private JDialog findReplaceDialog;

    public EditFindReplaceAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke, VenusUI venusUI) {
        super(string, icon, string2, n, keyStroke);
        this.mainPane = venusUI.getMainPane();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.findReplaceDialog = new FindReplaceDialog(Globals.getGui(), DIALOG_TITLE, false);
        this.findReplaceDialog.setVisible(true);
    }

    private class FindReplaceDialog
    extends JDialog {
        JButton findButton;
        JButton replaceButton;
        JButton replaceAllButton;
        JButton closeButton;
        JTextField findInputField;
        JTextField replaceInputField;
        JCheckBox caseSensitiveCheckBox;
        JRadioButton linearFromStart;
        JRadioButton circularFromCursor;
        private JLabel resultsLabel;
        public static final String FIND_TOOL_TIP_TEXT = "Find next occurrence of given text; wraps around at end";
        public static final String REPLACE_TOOL_TIP_TEXT = "Replace current occurrence of text then find next";
        public static final String REPLACE_ALL_TOOL_TIP_TEXT = "Replace all occurrences of text";
        public static final String CLOSE_TOOL_TIP_TEXT = "Close the dialog";
        public static final String RESULTS_TOOL_TIP_TEXT = "Outcome of latest operation (button click)";
        public static final String RESULTS_TEXT_FOUND = "Text found";
        public static final String RESULTS_TEXT_NOT_FOUND = "Text not found";
        public static final String RESULTS_TEXT_REPLACED = "Text replaced and found next";
        public static final String RESULTS_TEXT_REPLACED_LAST = "Text replaced; last occurrence";
        public static final String RESULTS_TEXT_REPLACED_ALL = "Replaced";
        public static final String RESULTS_NO_TEXT_TO_FIND = "No text to find";

        public FindReplaceDialog(Frame frame, String string, boolean bl) {
            super(frame, string, bl);
            this.setContentPane(this.buildDialogPanel());
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    FindReplaceDialog.this.performClose();
                }
            });
            this.pack();
            this.setLocationRelativeTo(frame);
        }

        private JPanel buildDialogPanel() {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
            jPanel.add(this.buildInputPanel(), "North");
            jPanel.add(this.buildOptionsPanel());
            jPanel.add(this.buildControlPanel(), "South");
            return jPanel;
        }

        private Component buildInputPanel() {
            this.findInputField = new JTextField(30);
            if (searchString.length() > 0) {
                this.findInputField.setText(searchString);
                this.findInputField.selectAll();
            }
            this.replaceInputField = new JTextField(30);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 5, 5));
            JPanel jPanel3 = new JPanel(new GridLayout(2, 1, 5, 5));
            jPanel2.add(new JLabel("Find what:"));
            jPanel2.add(new JLabel("Replace with:"));
            jPanel3.add(this.findInputField);
            jPanel3.add(this.replaceInputField);
            Box box = Box.createHorizontalBox();
            box.add(jPanel2);
            box.add(Box.createHorizontalStrut(6));
            box.add(jPanel3);
            jPanel.add(box);
            return jPanel;
        }

        private Component buildOptionsPanel() {
            Box box = Box.createHorizontalBox();
            this.caseSensitiveCheckBox = new JCheckBox("Case Sensitive", caseSensitivity);
            JPanel jPanel = new JPanel(new GridLayout(2, 1));
            jPanel.add(this.caseSensitiveCheckBox);
            jPanel.setMaximumSize(jPanel.getPreferredSize());
            box.add(jPanel);
            box.add(Box.createHorizontalStrut(5));
            JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
            jPanel2.setBorder(BorderFactory.createTitledBorder("Outcome"));
            this.resultsLabel = new JLabel("");
            this.resultsLabel.setForeground(Color.RED);
            this.resultsLabel.setToolTipText(RESULTS_TOOL_TIP_TEXT);
            jPanel2.add(this.resultsLabel);
            box.add(jPanel2);
            return box;
        }

        private Component buildControlPanel() {
            Box box = Box.createHorizontalBox();
            box.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
            this.findButton = new JButton("Find");
            this.findButton.setToolTipText(FIND_TOOL_TIP_TEXT);
            this.findButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FindReplaceDialog.this.performFind();
                }
            });
            this.replaceButton = new JButton("Replace then Find");
            this.replaceButton.setToolTipText(REPLACE_TOOL_TIP_TEXT);
            this.replaceButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FindReplaceDialog.this.performReplace();
                }
            });
            this.replaceAllButton = new JButton("Replace all");
            this.replaceAllButton.setToolTipText(REPLACE_ALL_TOOL_TIP_TEXT);
            this.replaceAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FindReplaceDialog.this.performReplaceAll();
                }
            });
            this.closeButton = new JButton("Close");
            this.closeButton.setToolTipText(CLOSE_TOOL_TIP_TEXT);
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FindReplaceDialog.this.performClose();
                }
            });
            box.add(Box.createHorizontalGlue());
            box.add(this.findButton);
            box.add(Box.createHorizontalGlue());
            box.add(this.replaceButton);
            box.add(Box.createHorizontalGlue());
            box.add(this.replaceAllButton);
            box.add(Box.createHorizontalGlue());
            box.add(this.closeButton);
            box.add(Box.createHorizontalGlue());
            return box;
        }

        private void performFind() {
            this.resultsLabel.setText("");
            if (this.findInputField.getText().length() > 0) {
                EditPane editPane = EditFindReplaceAction.this.mainPane.getEditPane();
                if (editPane != null) {
                    searchString = this.findInputField.getText();
                    int n = editPane.doFindText(searchString, this.caseSensitiveCheckBox.isSelected());
                    if (n == 0) {
                        this.resultsLabel.setText(this.findButton.getText() + ": " + RESULTS_TEXT_NOT_FOUND);
                    } else {
                        this.resultsLabel.setText(this.findButton.getText() + ": " + RESULTS_TEXT_FOUND);
                    }
                }
            } else {
                this.resultsLabel.setText(this.findButton.getText() + ": " + RESULTS_NO_TEXT_TO_FIND);
            }
        }

        private void performReplace() {
            this.resultsLabel.setText("");
            if (this.findInputField.getText().length() > 0) {
                EditPane editPane = EditFindReplaceAction.this.mainPane.getEditPane();
                if (editPane != null) {
                    searchString = this.findInputField.getText();
                    int n = editPane.doReplace(searchString, this.replaceInputField.getText(), this.caseSensitiveCheckBox.isSelected());
                    String string = this.replaceButton.getText() + ": ";
                    switch (n) {
                        case 0: {
                            string = string + RESULTS_TEXT_NOT_FOUND;
                            break;
                        }
                        case 1: {
                            string = string + RESULTS_TEXT_FOUND;
                            break;
                        }
                        case 3: {
                            string = string + RESULTS_TEXT_REPLACED_LAST;
                            break;
                        }
                        case 2: {
                            string = string + RESULTS_TEXT_REPLACED;
                        }
                    }
                    this.resultsLabel.setText(string);
                }
            } else {
                this.resultsLabel.setText(this.replaceButton.getText() + ": " + RESULTS_NO_TEXT_TO_FIND);
            }
        }

        private void performReplaceAll() {
            this.resultsLabel.setText("");
            if (this.findInputField.getText().length() > 0) {
                EditPane editPane = EditFindReplaceAction.this.mainPane.getEditPane();
                if (editPane != null) {
                    searchString = this.findInputField.getText();
                    int n = editPane.doReplaceAll(searchString, this.replaceInputField.getText(), this.caseSensitiveCheckBox.isSelected());
                    if (n == 0) {
                        this.resultsLabel.setText(this.replaceAllButton.getText() + ": " + RESULTS_TEXT_NOT_FOUND);
                    } else {
                        this.resultsLabel.setText(this.replaceAllButton.getText() + ": " + RESULTS_TEXT_REPLACED_ALL + " " + n + " occurrence" + (n == 1 ? "" : "s"));
                    }
                }
            } else {
                this.resultsLabel.setText(this.replaceAllButton.getText() + ": " + RESULTS_NO_TEXT_TO_FIND);
            }
        }

        private void performClose() {
            caseSensitivity = this.caseSensitiveCheckBox.isSelected();
            this.setVisible(false);
            this.dispose();
        }
    }
}

