/*
 * Decompiled with CFR 0.152.
 */
package rars.venus;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import rars.Globals;
import rars.assembler.Directives;
import rars.riscv.AbstractSyscall;
import rars.riscv.BasicInstruction;
import rars.riscv.ExtendedInstruction;
import rars.riscv.Instruction;
import rars.riscv.SyscallLoader;
import rars.venus.GuiAction;
import rars.venus.VenusUI;

public class HelpHelpAction
extends GuiAction {
    private VenusUI mainUI;
    static Color altBackgroundColor = new Color(238, 238, 238);
    public static final String descriptionDetailSeparator = ":";

    public HelpHelpAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke, VenusUI venusUI) {
        super(string, icon, string2, n, keyStroke);
        this.mainUI = venusUI;
    }

    private Dimension getSize() {
        return new Dimension(800, 600);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("RISCV", this.createHelpInfoPanel());
        jTabbedPane.addTab("RARS", this.createRarsHelpInfoPanel());
        jTabbedPane.addTab("License", this.createCopyrightInfoPanel());
        jTabbedPane.addTab("Bugs/Comments", this.createHTMLHelpPanel("BugReportingHelp.html"));
        jTabbedPane.addTab("Acknowledgements", this.createHTMLHelpPanel("Acknowledgements.html"));
        final JDialog jDialog = new JDialog((Frame)this.mainUI, "RARS 1.6 Help");
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        });
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jPanel2.add(jTabbedPane);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel2.add(jPanel);
        jPanel2.setOpaque(true);
        jDialog.setContentPane(jPanel2);
        jDialog.setSize(this.getSize());
        jDialog.setLocationRelativeTo(this.mainUI);
        jDialog.setVisible(true);
    }

    private JPanel createHTMLHelpPanel(String string) {
        JScrollPane jScrollPane;
        JPanel jPanel = new JPanel(new BorderLayout());
        try {
            StringBuilder stringBuilder = this.loadFiletoStringBuilder("/help/" + string);
            JEditorPane jEditorPane = new JEditorPane("text/html", stringBuilder.toString());
            jEditorPane.setEditable(false);
            jEditorPane.setCaretPosition(0);
            jScrollPane = new JScrollPane(jEditorPane, 22, 30);
            jEditorPane.addHyperlinkListener(new HelpHyperlinkListener());
        }
        catch (Exception exception) {
            jScrollPane = new JScrollPane(new JLabel("Error (" + exception + "): " + string + " contents could not be loaded."));
        }
        jPanel.add(jScrollPane);
        return jPanel;
    }

    private JPanel createCopyrightInfoPanel() {
        JScrollPane jScrollPane;
        JPanel jPanel = new JPanel(new BorderLayout());
        try {
            StringBuilder stringBuilder = this.loadFiletoStringBuilder("/License.txt").append("</pre>");
            JEditorPane jEditorPane = new JEditorPane("text/html", "<pre>" + stringBuilder.toString());
            jEditorPane.setEditable(false);
            jEditorPane.setCaretPosition(0);
            jScrollPane = new JScrollPane(jEditorPane, 22, 30);
        }
        catch (Exception exception) {
            jScrollPane = new JScrollPane(new JLabel("Error: license contents could not be loaded."));
        }
        jPanel.add(jScrollPane);
        return jPanel;
    }

    private JPanel createRarsHelpInfoPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Intro", this.createHTMLHelpPanel("Intro.html"));
        jTabbedPane.addTab("IDE", this.createHTMLHelpPanel("IDE.html"));
        jTabbedPane.addTab("Debugging", this.createHTMLHelpPanel("Debugging.html"));
        jTabbedPane.addTab("Tools", this.createHTMLHelpPanel("Tools.html"));
        jTabbedPane.addTab("Command", this.createHTMLHelpPanel("Command.html"));
        jTabbedPane.addTab("Limits", this.createHTMLHelpPanel("Limits.html"));
        jTabbedPane.addTab("History", this.createHTMLHelpPanel("History.html"));
        jPanel.add(jTabbedPane);
        return jPanel;
    }

    private JPanel createHelpInfoPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        String string = "CCFF99";
        String string2 = "<html><center><table bgcolor=\"#" + string + "\" border=0 cellpadding=0><tr><th colspan=2><b><i><font size=+1>&nbsp;&nbsp;Operand Key for Example Instructions&nbsp;&nbsp;</font></i></b></th></tr><tr><td><tt>label, target</tt></td><td>any textual label</td></tr><tr><td><tt>t1, t2, t3</tt></td><td>any integer register</td></tr><tr><td><tt>f2, f4, f6</tt></td><td><i>even-numbered</i> floating point register</td></tr><tr><td><tt>f0, f1, f3</tt></td><td><i>any</i> floating point register</td></tr><tr><td><tt>10</tt></td><td>unsigned 5-bit integer (0 to 31)</td></tr><tr><td><tt>-100</tt></td><td>signed 16-bit integer (-32768 to 32767)</td></tr><tr><td><tt>100</tt></td><td>unsigned 16-bit integer (0 to 65535)</td></tr><tr><td><tt>100000</tt></td><td>signed 32-bit integer (-2147483648 to 2147483647)</td></tr><tr></tr><tr><td colspan=2><b><i><font size=+1>Load & Store addressing mode, basic instructions</font></i></b></td></tr><tr><td><tt>-100(t2)</tt></td><td>sign-extended 16-bit integer added to contents of t2</td></tr><tr></tr><tr><td colspan=2><b><i><font size=+1>Load & Store addressing modes, pseudo instructions</font></i></b></td></tr><tr><td><tt>(t2)</tt></td><td>contents of t2</td></tr><tr><td><tt>-100</tt></td><td>signed 16-bit integer</td></tr><tr><td><tt>100</tt></td><td>unsigned 16-bit integer</td></tr><tr><td><tt>100000</tt></td><td>signed 32-bit integer</td></tr><tr><td><tt>100(t2)</tt></td><td>zero-extended unsigned 16-bit integer added to contents of t2</td></tr><tr><td><tt>100000(t2)</tt></td><td>signed 32-bit integer added to contents of t2</td></tr><tr><td><tt>label</tt></td><td>32-bit address of label</td></tr><tr><td><tt>label(t2)</tt></td><td>32-bit address of label added to contents of t2</td></tr><tr><td><tt>label+100000</tt></td><td>32-bit integer added to label's address</td></tr><tr><td><tt>label+100000(t2)&nbsp;&nbsp;&nbsp;</tt></td><td>sum of 32-bit integer, label's address, and contents of t2</td></tr></table></center></html>";
        JLabel jLabel = new JLabel(string2, 0);
        jLabel.setOpaque(true);
        jLabel.setBackground(Color.decode("0x" + string));
        JScrollPane jScrollPane = new JScrollPane(jLabel, 22, 32);
        jPanel.add((Component)jScrollPane, "North");
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Basic Instructions", this.createInstructionHelpPane(BasicInstruction.class));
        jTabbedPane.addTab("Extended (pseudo) Instructions", this.createInstructionHelpPane(ExtendedInstruction.class));
        jTabbedPane.addTab("Directives", this.createDirectivesHelpPane());
        jTabbedPane.addTab("Syscalls", this.createSyscallsHelpPane());
        jTabbedPane.addTab("Exceptions", this.createHTMLHelpPanel("ExceptionsHelp.html"));
        jTabbedPane.addTab("Macros", this.createHTMLHelpPanel("MacrosHelp.html"));
        jScrollPane.setPreferredSize(new Dimension((int)this.getSize().getWidth(), (int)(this.getSize().getHeight() * 0.2)));
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jTabbedPane.setPreferredSize(new Dimension((int)this.getSize().getWidth(), (int)(this.getSize().getHeight() * 0.6)));
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jTabbedPane);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.resetToPreferredSizes();
        jPanel.add(jSplitPane);
        return jPanel;
    }

    private JScrollPane createDirectivesHelpPane() {
        Vector<String> vector = new Vector<String>();
        String string = "            ";
        for (Directives object2 : Directives.getDirectiveList()) {
            vector.add(object2.toString() + string.substring(0, Math.max(0, string.length() - object2.toString().length())) + object2.getDescription());
        }
        Collections.sort(vector);
        JList jList = new JList(vector);
        JScrollPane jScrollPane = new JScrollPane(jList, 22, 30);
        jList.setFont(new Font("Monospaced", 0, 12));
        return jScrollPane;
    }

    private JScrollPane createSyscallsHelpPane() {
        ArrayList<AbstractSyscall> arrayList = SyscallLoader.getSyscallList();
        String[] stringArray = new String[]{"Name", "Number", "Description", "Inputs", "Ouputs"};
        String[][] stringArray2 = new String[arrayList.size()][5];
        Collections.sort(arrayList);
        int n = 0;
        for (AbstractSyscall abstractSyscall : arrayList) {
            stringArray2[n][0] = abstractSyscall.getName();
            stringArray2[n][1] = Integer.toString(abstractSyscall.getNumber());
            stringArray2[n][2] = abstractSyscall.getDescription();
            stringArray2[n][3] = abstractSyscall.getInputs();
            stringArray2[n][4] = abstractSyscall.getOutputs();
            ++n;
        }
        JEditorPane jEditorPane = new JEditorPane("text/html", this.loadFiletoStringBuilder("/help/SyscallHelpPrelude.html") + this.convertToHTMLTable(stringArray2, stringArray).toString() + this.loadFiletoStringBuilder("/help/SyscallHelpConclusion.html"));
        jEditorPane.setCaretPosition(0);
        jEditorPane.setEditable(false);
        return new JScrollPane(jEditorPane, 22, 30);
    }

    private JScrollPane createInstructionHelpPane(Class<? extends Instruction> clazz) {
        ArrayList<Instruction> arrayList = Globals.instructionSet.getInstructionList();
        Vector<String> vector = new Vector<String>(arrayList.size());
        String string = "                        ";
        for (Instruction object2 : arrayList) {
            if (!clazz.isInstance(object2)) continue;
            vector.add(object2.getExampleFormat() + string.substring(0, Math.max(0, string.length() - object2.getExampleFormat().length())) + object2.getDescription());
        }
        Collections.sort(vector);
        JList jList = new JList(vector);
        JScrollPane jScrollPane = new JScrollPane(jList, 22, 30);
        jList.setFont(new Font("Monospaced", 0, 12));
        jList.setCellRenderer(new MyCellRenderer());
        return jScrollPane;
    }

    private StringBuilder convertToHTMLTable(String[][] stringArray, String[] stringArray2) {
        StringBuilder stringBuilder = new StringBuilder("<table border=1>");
        stringBuilder.append("<tr>");
        for (String string : stringArray2) {
            stringBuilder.append("<td>").append(string).append("</td>");
        }
        stringBuilder.append("</tr>");
        for (String string : stringArray) {
            stringBuilder.append("<tr>");
            for (String string2 : string) {
                stringBuilder.append("<td>").append(string2).append("</td>");
            }
            stringBuilder.append("</tr>");
        }
        stringBuilder.append("</table>");
        return stringBuilder;
    }

    private StringBuilder loadFiletoStringBuilder(String string) {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append("\n");
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return new StringBuilder(string + " could not be loaded.");
        }
        return stringBuilder;
    }

    private class HelpHyperlinkListener
    implements HyperlinkListener {
        JDialog webpageDisplay;
        JTextField webpageURL;
        private static final String cannotDisplayMessage = "<html><title></title><body><strong>Unable to display requested document.</strong></body></html>";

        private HelpHyperlinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                    HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                    hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                } else {
                    JEditorPane jEditorPane2;
                    this.webpageDisplay = new JDialog((Frame)HelpHelpAction.this.mainUI, "Primitive HTML Viewer");
                    this.webpageDisplay.setLayout(new BorderLayout());
                    this.webpageDisplay.setLocation(((HelpHelpAction)HelpHelpAction.this).mainUI.getSize().width / 6, ((HelpHelpAction)HelpHelpAction.this).mainUI.getSize().height / 6);
                    try {
                        jEditorPane2 = new JEditorPane(hyperlinkEvent.getURL());
                    }
                    catch (Throwable throwable) {
                        jEditorPane2 = new JEditorPane("text/html", cannotDisplayMessage);
                    }
                    jEditorPane2.addHyperlinkListener(new HyperlinkListener(){

                        @Override
                        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                                    HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                                    HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                                    hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                                } else {
                                    try {
                                        jEditorPane.setPage(hyperlinkEvent.getURL());
                                    }
                                    catch (Throwable throwable) {
                                        jEditorPane.setText(HelpHyperlinkListener.cannotDisplayMessage);
                                    }
                                    HelpHyperlinkListener.this.webpageURL.setText(hyperlinkEvent.getURL().toString());
                                }
                            }
                        }
                    });
                    jEditorPane2.setPreferredSize(new Dimension(((HelpHelpAction)HelpHelpAction.this).mainUI.getSize().width * 2 / 3, ((HelpHelpAction)HelpHelpAction.this).mainUI.getSize().height * 2 / 3));
                    jEditorPane2.setEditable(false);
                    jEditorPane2.setCaretPosition(0);
                    JScrollPane jScrollPane = new JScrollPane(jEditorPane2, 20, 30);
                    this.webpageURL = new JTextField(hyperlinkEvent.getURL().toString(), 50);
                    this.webpageURL.setEditable(false);
                    this.webpageURL.setBackground(Color.WHITE);
                    JPanel jPanel = new JPanel(new FlowLayout(0, 4, 4));
                    jPanel.add(new JLabel("URL: "));
                    jPanel.add(this.webpageURL);
                    this.webpageDisplay.add((Component)jPanel, "North");
                    this.webpageDisplay.add(jScrollPane);
                    JButton jButton = new JButton("Close");
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            HelpHyperlinkListener.this.webpageDisplay.setVisible(false);
                            HelpHyperlinkListener.this.webpageDisplay.dispose();
                        }
                    });
                    JPanel jPanel2 = new JPanel();
                    jPanel2.setLayout(new BoxLayout(jPanel2, 2));
                    jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
                    jPanel2.add(Box.createHorizontalGlue());
                    jPanel2.add(jButton);
                    jPanel2.add(Box.createHorizontalGlue());
                    this.webpageDisplay.add((Component)jPanel2, "South");
                    this.webpageDisplay.pack();
                    this.webpageDisplay.setVisible(true);
                }
            }
        }
    }

    private class MyCellRenderer
    extends JLabel
    implements ListCellRenderer<String> {
        private MyCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> jList, String string, int n, boolean bl, boolean bl2) {
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(n % 2 == 0 ? altBackgroundColor : jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

