#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>  /* uint64_t */
#include <omp.h>

int t; //threashold

// reference version
inline uint64_t seqfib(int n)
{
    return n < 2 ? n : seqfib(n-1) + seqfib(n-2);
}


uint64_t fib(int n) {
//    printf("X: Current thread %d of %d threads\n", omp_get_thread_num(), omp_get_num_threads());
    if (n < 2)
        return n;
    else if (n <= t) return seqfib(n);
    else {
        uint64_t x, y;
#pragma omp task shared(x)
        x = fib(n-1);
#pragma omp task shared(y)
        y = fib(n-2);
#pragma omp taskwait
        return x + y;
    }
}



int main(int argc, char**argv) {
    int status;
    uint64_t result;
    if (argc < 2) return 1;
    int n = atoi(argv[1]);
    t = atoi(argv[2]);
#pragma omp parallel
#pragma omp single
    {
    result = fib(n);
    }
    printf("Fibonacci of %d is %ld\n", n, result);
    return 0;
}

