#include <tbb/tbb.h>
#include <iostream>
#include <cstdlib>

using namespace tbb;
using namespace std;

int t; //threashold

// reference version
inline uint64_t seqfib(int n)
{
    return n < 2 ? n : seqfib(n-1) + seqfib(n-2);
}

class FibTask: public task {
public:
    const long n;
    long* const sum;
    FibTask( long n_, long* sum_ ) :
             n(n_), sum(sum_) {}
    task* execute() {
        if( n < 2 ) {
            *sum = n;
        } else if (n <= t) {
            *sum = seqfib(n);
        } else {
            long x, y;
            // Create task a to compute fib(n-1)
            FibTask& a = *new( allocate_child() )
                    FibTask(n-1,&x);
            // Create task b to compute fib(n-2)
            FibTask& b = *new( allocate_child() )
                    FibTask(n-2, &y);
            // Set ref_count to "two children plus one for the wait"
            set_ref_count(3);
            // Spawn task b
            spawn( b );
            // Spawn task a and wait for a and b
            spawn_and_wait_for_all( a );
            *sum = x+y;
        }
        return NULL;
    }
};


int main(int argc, char **argv) {
    long sum;
    if (argc < 2) 
        return 1;
    int n = atoi(argv[1]);
    t = atoi(argv[2]);
    int w = tbb::task_scheduler_init::automatic;
    const char *tnt = getenv("TBB_NUM_THREADS");
    if (tnt) { w = atoi(tnt); } // n. of workers
    task_scheduler_init init(w);
cout << "w=" << w << endl;
    FibTask& a = *new(task::allocate_root()) FibTask(n, &sum);
    task::spawn_root_and_wait(a);
    cout << "Fibonacci of " << n << " is " << sum << endl;
}

